/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2.optional;

import com.filemaker.jdbc2.optional.BaseDataSource;
import com.filemaker.jdbc2.optional.ConnectionPool;
import com.filemaker.jdbc2.optional.PoolingDataSource;
import com.filemaker.jdbc2.optional.SimpleDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class FMObjectFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        if (reference.getClassName().equals(SimpleDataSource.class.getName())) {
            return this.loadSimpleDataSource(reference);
        }
        if (reference.getClassName().equals(ConnectionPool.class.getName())) {
            return this.loadConnectionPool(reference);
        }
        if (reference.getClassName().equals(PoolingDataSource.class.getName())) {
            return this.loadPoolingDataSource(reference);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference reference) {
        String string;
        String string2 = this.getProperty(reference, "dataSourceName");
        PoolingDataSource poolingDataSource = PoolingDataSource.getDataSource(string2);
        if (poolingDataSource != null) {
            return poolingDataSource;
        }
        poolingDataSource = new PoolingDataSource();
        poolingDataSource.setDataSourceName(string2);
        this.loadBaseDataSource(poolingDataSource, reference);
        String string3 = this.getProperty(reference, "initialConnections");
        if (string3 != null) {
            poolingDataSource.setInitialConnections(Integer.parseInt(string3));
        }
        if ((string = this.getProperty(reference, "maxConnections")) != null) {
            poolingDataSource.setMaxConnections(Integer.parseInt(string));
        }
        return poolingDataSource;
    }

    private Object loadSimpleDataSource(Reference reference) {
        SimpleDataSource simpleDataSource = new SimpleDataSource();
        return this.loadBaseDataSource(simpleDataSource, reference);
    }

    private Object loadConnectionPool(Reference reference) {
        ConnectionPool connectionPool = new ConnectionPool();
        return this.loadBaseDataSource(connectionPool, reference);
    }

    protected Object loadBaseDataSource(BaseDataSource baseDataSource, Reference reference) {
        baseDataSource.setDatabaseName(this.getProperty(reference, "databaseName"));
        baseDataSource.setPassword(this.getProperty(reference, "password"));
        String string = this.getProperty(reference, "portNumber");
        if (string != null) {
            baseDataSource.setPortNumber(Integer.parseInt(string));
        }
        baseDataSource.setServerName(this.getProperty(reference, "serverName"));
        baseDataSource.setUser(this.getProperty(reference, "user"));
        return baseDataSource;
    }

    protected String getProperty(Reference reference, String string) {
        RefAddr refAddr = reference.get(string);
        if (refAddr == null) {
            return null;
        }
        return (String)refAddr.getContent();
    }
}

