/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMColumnValue;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.FM_API;
import com.filemaker.jdbc.Field;
import com.filemaker.util.FMobject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.cert.X509Certificate;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public abstract class CommonJ1Statement
implements BaseStatement {
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 5000;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected BaseResultSet result = null;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private StringBuffer sbuf = new StringBuffer(32);
    protected String[] m_sqlFragments;
    private String[] m_executeSqlFragments;
    protected Object[] m_binds = new Object[0];
    protected String[] m_bindTypes = new String[0];
    protected String m_statementName = null;
    protected String m_cursorName = null;
    private int commandID = -1;
    protected long lastRowID = 0L;
    protected int batchIndex = 0;
    protected Vector<Long> lastRowIDs = null;
    private static final short UNKNOWN = 0;
    private static final short NO = 1;
    private static final short YES = 2;
    private short m_isSingleDML = 0;
    private short m_isSingleSelect = 0;
    private short m_isSingleStatement = 0;
    private boolean m_useServerPrepare = false;
    protected boolean isClosed = false;
    protected boolean isPrepared = false;
    private static int m_preparedCount = 1;
    private static final String JDBC_SYNTAX = "{[? =] call <some_function> ([? [,?]*]) }";
    private static final String RESULT_ALIAS = "result";
    private String originalSql = "";
    private boolean isFunction;
    private int functionReturnType;
    private int testReturn;
    private boolean returnTypeSet;
    protected Object callResult;
    protected int maxfieldSize = 0;
    private static final String FM_TEXT = "varchar";
    private static final String FM_INTEGER = "int";
    private static final String FM_NUMERIC = "numeric";
    private static final String FM_DATE = "date";
    private static final String FM_TIME = "time";
    private static final String FM_TIMESTAMP = "timestamp";
    private static final String FM_BLOB = "blob";
    private static final String FM_STREAM = "stream";

    private static synchronized int next_preparedCount() {
        return m_preparedCount++;
    }

    @Override
    public abstract BaseResultSet createResultSet(int var1, Field[] var2, Vector var3, String var4, int var5, long var6, boolean var8) throws SQLException;

    public CommonJ1Statement(BaseConnection baseConnection) {
        this.connection = baseConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonJ1Statement(BaseConnection baseConnection, String string) throws SQLException {
        this.connection = baseConnection;
        this.parseSqlStmt(string);
        String[] stringArray = this.getQueryFragments();
        String string2 = this.m_sqlFragments[0].trim().toLowerCase();
        String[] stringArray2 = string2.split(" ");
        if (stringArray2.length >= 2 && stringArray2[0].startsWith("show")) {
            if (stringArray2[1].startsWith("encryption")) {
                this.getEncryptionStatus();
            } else {
                if (!stringArray2[1].startsWith("cacerts")) throw new FMSQLException("Syntax error: SHOW statement", 27115);
                this.showCaCerts();
            }
        } else if (baseConnection.getProtocolVersion() == 9) {
            this.commandID = FM_API.prepare(stringArray, this.m_binds, this);
        } else {
            this.result = FM_API.prepareRS(stringArray, this.m_binds, this);
            if (this.result != null) {
                this.commandID = this.result.getCommandID();
            }
        }
        this.isPrepared = true;
    }

    @Override
    public BaseConnection getFMConnection() {
        return this.connection;
    }

    @Override
    public String getFetchingCursorName() {
        return this.m_cursorName;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setLastRowID(long l) {
        this.lastRowID = l;
        if (this.lastRowIDs != null) {
            this.lastRowIDs.addElement(this.lastRowID);
        }
    }

    protected void parseSqlStmt(String string) throws SQLException {
        int n;
        String string2 = string;
        string2 = this.replaceProcessing(string2);
        if (this instanceof CallableStatement) {
            string2 = this.modifyJdbcCall(string2);
        }
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n2 = 0;
        this.m_isSingleDML = 0;
        this.m_isSingleSelect = 0;
        this.m_isSingleStatement = (short)2;
        for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            if (c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (c == '?' && !bl) {
                vector.addElement(string2.substring(n2, n));
                n2 = n + 1;
            }
            if (c != ';' || bl) continue;
            this.m_isSingleDML = 1;
            this.m_isSingleSelect = 1;
            this.m_isSingleStatement = 1;
        }
        vector.addElement(string2.substring(n2, string2.length()));
        this.m_sqlFragments = new String[vector.size()];
        this.m_binds = new Object[vector.size() - 1];
        this.m_bindTypes = new String[vector.size() - 1];
        for (n = 0; n < this.m_sqlFragments.length; ++n) {
            this.m_sqlFragments[n] = (String)vector.elementAt(n);
        }
    }

    private void deallocateQuery() {
        if (this.m_statementName != null) {
            // empty if block
        }
        this.m_statementName = null;
        this.m_cursorName = null;
        this.m_executeSqlFragments = null;
        this.m_isSingleDML = 0;
        this.m_isSingleSelect = 0;
        this.m_isSingleStatement = 0;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.executeQuery(\"" + string + "\");");
        }
        this.deallocateQuery();
        String string2 = this.replaceProcessing(string);
        this.m_sqlFragments = new String[]{string2};
        this.m_binds = new Object[0];
        return this.executeQuery();
    }

    public ResultSet executeQuery() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.executeQuery();");
        }
        if (this.isPrepared) {
            this.execute();
        } else {
            this.execDirect();
        }
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new FMSQLException("No results were returned by the query.", "02000", 27110);
        }
        return (ResultSet)((Object)this.result);
    }

    public int executeUpdate(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.executeUpdate(\"" + string + "\");");
        }
        this.deallocateQuery();
        String string2 = this.replaceProcessing(string);
        this.m_sqlFragments = new String[]{string2};
        this.m_binds = new Object[0];
        return this.executeUpdate();
    }

    public int executeUpdate() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.executeUpdate();");
        }
        if (this.isPrepared) {
            this.execute();
        } else {
            this.execDirect();
        }
        if (this.result.reallyResultSet()) {
            throw new FMSQLException("A result was returned when none was expected.", 27111);
        }
        return this.getUpdateCount();
    }

    public boolean execute(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.execute(\"" + string + "\");");
        }
        this.deallocateQuery();
        String string2 = this.replaceProcessing(string);
        this.m_sqlFragments = new String[]{string2};
        this.m_binds = new Object[0];
        return this.execDirect();
    }

    private boolean isSingleStatement() {
        if (this.m_isSingleStatement != 0) {
            return this.m_isSingleStatement == 2;
        }
        for (int i = 0; i < this.m_sqlFragments.length; ++i) {
            if (this.m_sqlFragments[i].indexOf(59) == -1) continue;
            this.m_isSingleStatement = 1;
            return false;
        }
        this.m_isSingleStatement = (short)2;
        return true;
    }

    private void analyzeStatementType() {
        if (!this.isSingleStatement()) {
            this.m_isSingleDML = 1;
            this.m_isSingleSelect = 1;
            return;
        }
        String string = this.m_sqlFragments[0].trim().toLowerCase();
        if (string.startsWith("select") || string.startsWith("show")) {
            this.m_isSingleDML = (short)2;
            this.m_isSingleSelect = (short)2;
            return;
        }
        this.m_isSingleSelect = 1;
        if (!(string.startsWith("update") || string.startsWith("delete") || string.startsWith("insert"))) {
            this.m_isSingleDML = 1;
            return;
        }
        this.m_isSingleDML = (short)2;
    }

    protected boolean isSingleSelect() {
        if (this.m_isSingleSelect == 0) {
            this.analyzeStatementType();
        }
        return this.m_isSingleSelect == 2;
    }

    private boolean isSingleDML() {
        if (this.m_isSingleDML == 0) {
            this.analyzeStatementType();
        }
        return this.m_isSingleDML == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] transformToServerPrepare() {
        if (this.m_statementName != null) {
            return this.m_executeSqlFragments;
        }
        this.m_statementName = "JDBC_STATEMENT_" + m_preparedCount++;
        this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
        this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
        if (this.m_sqlFragments.length > 1) {
            this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
            for (int i = 1; i < this.m_bindTypes.length; ++i) {
                this.m_executeSqlFragments[i] = ", ";
            }
            this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
        }
        String[] stringArray = new String[this.m_sqlFragments.length];
        System.arraycopy(this.m_sqlFragments, 0, stringArray, 0, this.m_sqlFragments.length);
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            int n;
            this.sbuf.setLength(0);
            this.sbuf.append("PREPARE ");
            this.sbuf.append(this.m_statementName);
            if (this.m_sqlFragments.length > 1) {
                this.sbuf.append("(");
                for (n = 0; n < this.m_bindTypes.length; ++n) {
                    if (n != 0) {
                        this.sbuf.append(", ");
                    }
                    this.sbuf.append(this.m_bindTypes[n]);
                }
                this.sbuf.append(")");
            }
            this.sbuf.append(" AS ");
            this.sbuf.append(this.m_sqlFragments[0]);
            for (n = 1; n < this.m_sqlFragments.length; ++n) {
                this.sbuf.append(" $");
                this.sbuf.append(n);
                this.sbuf.append(" ");
                this.sbuf.append(this.m_sqlFragments[n]);
            }
            this.sbuf.append("; ");
            this.sbuf.append(this.m_executeSqlFragments[0]);
            stringArray[0] = this.sbuf.toString();
        }
        System.arraycopy(this.m_executeSqlFragments, 1, stringArray, 1, stringArray.length - 1);
        return stringArray;
    }

    private String[] transformToCursorFetch() {
        this.m_cursorName = "JDBC_CURS_" + m_preparedCount++;
        int n = this.m_sqlFragments.length;
        String[] stringArray = new String[n];
        System.arraycopy(this.m_sqlFragments, 0, stringArray, 0, n);
        stringArray[0] = "DECLARE " + this.m_cursorName + " CURSOR FOR " + stringArray[0];
        if (Driver.logDebug) {
            Driver.debug("using cursor based sql with cursor name " + this.m_cursorName);
        }
        return stringArray;
    }

    protected boolean useCursorFetch() {
        return this.fetchSize > 0 && !this.connection.getAutoCommit() && this.isSingleSelect();
    }

    private String[] getQueryFragments() {
        if (this.useCursorFetch()) {
            return this.transformToCursorFetch();
        }
        if (this.isUseServerPrepare() && this.isSingleDML()) {
            return this.transformToServerPrepare();
        }
        return this.m_sqlFragments;
    }

    private void getEncryptionStatus() throws SQLException {
        byte[] byArray;
        byte[] byArray2;
        FMColumnValue[] fMColumnValueArray;
        Field[] fieldArray = new Field[2];
        Vector<FMColumnValue[]> vector = new Vector<FMColumnValue[]>();
        fieldArray[0] = new Field(this.connection, "NAME", 12, -1L);
        fieldArray[1] = new Field(this.connection, "VALUE", 12, -1L);
        FMColumnValue[] fMColumnValueArray2 = new FMColumnValue[2];
        Encoding encoding = this.connection.getEncoding();
        byte[] byArray3 = encoding.encode("ENCRYPTION");
        FMStream fMStream = this.connection.getFMStream();
        String string = fMStream.encryptionMethod;
        byte[] byArray4 = encoding.encode(string);
        fMColumnValueArray2[0] = new FMColumnValue(1, 0, byArray3.length, byArray3);
        fMColumnValueArray2[1] = new FMColumnValue(2, 0, byArray4.length, byArray4);
        vector.addElement(fMColumnValueArray2);
        if (!fMStream.sslSubject.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL CERTIFICATE");
            byArray = encoding.encode(fMStream.sslSubject);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.sslAlternateNames.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL ALTERNATE NAMES");
            byArray = encoding.encode(fMStream.sslAlternateNames);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.issuerName.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL ISSUER");
            byArray = encoding.encode(fMStream.issuerName);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.certExpDate.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL EXPIRATION DATE");
            byArray = encoding.encode(fMStream.certExpDate);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.intermediateName.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL INTERMEDIATE");
            byArray = encoding.encode(fMStream.intermediateName);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.intermediateIssuer.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL INTERMEDIATE ISSUER");
            byArray = encoding.encode(fMStream.intermediateIssuer);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.intermediateExpDate.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("INTERMEDIATE EXPIRATION DATE");
            byArray = encoding.encode(fMStream.intermediateExpDate);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        if (!fMStream.sslStatus.isEmpty()) {
            fMColumnValueArray = new FMColumnValue[2];
            byArray2 = encoding.encode("SSL STATUS");
            byArray = encoding.encode(fMStream.sslStatus);
            fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray2.length, byArray2);
            fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray.length, byArray);
            vector.addElement(fMColumnValueArray);
        }
        this.result = this.createResultSet(-1, fieldArray, vector, "OK", 1, 0L, false);
    }

    private void showCaCerts() throws SQLException {
        Field[] fieldArray = new Field[3];
        Vector<FMColumnValue[]> vector = new Vector<FMColumnValue[]>();
        fieldArray[0] = new Field(this.connection, "SUBJECT", 12, -1L);
        fieldArray[1] = new Field(this.connection, "ISSUER", 12, -1L);
        fieldArray[2] = new Field(this.connection, "EXPIRATION DATE", 12, -1L);
        Encoding encoding = this.connection.getEncoding();
        FMStream fMStream = this.connection.getFMStream();
        X509Certificate[] x509CertificateArray = fMStream.caCerts;
        if (x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                FMColumnValue[] fMColumnValueArray = new FMColumnValue[3];
                X509Certificate x509Certificate = x509CertificateArray[i];
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                String string = FMStream.buildSubjectString(x500Principal.getName());
                java.util.Date date = x509Certificate.getNotAfter();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(calendar.get(1)).append("-").append(calendar.get(2) + 1).append("-").append(calendar.get(5));
                String string2 = stringBuilder.toString();
                X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                String string3 = FMStream.buildSubjectString(x500Principal2.getName());
                byte[] byArray = encoding.encode(string);
                byte[] byArray2 = encoding.encode(string3);
                byte[] byArray3 = encoding.encode(string2);
                fMColumnValueArray[0] = new FMColumnValue(1, 0, byArray.length, byArray);
                fMColumnValueArray[1] = new FMColumnValue(2, 0, byArray2.length, byArray2);
                fMColumnValueArray[2] = new FMColumnValue(3, 0, byArray3.length, byArray3);
                vector.addElement(fMColumnValueArray);
            }
        }
        this.result = this.createResultSet(-1, fieldArray, vector, "OK", 1, 0L, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execDirect() throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.execDirect();");
        }
        long l = System.currentTimeMillis();
        if (this.isClosed) {
            throw new FMSQLException("Statement has been closed.", 27113);
        }
        if (this.isFunction && !this.returnTypeSet) {
            throw new FMSQLException("CallableStatement function was declared but no call to registerOutParameterwas made.", "2F003", 27114);
        }
        if (this.isFunction) {
            this.m_binds[0] = "";
            this.m_bindTypes[0] = FM_TEXT;
        }
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        for (int i = 0; i < this.m_binds.length; ++i) {
            if (this.m_binds[i] != null) continue;
            throw new FMSQLException("Invalid parameter binding(s).", 27115);
        }
        String[] stringArray = this.getQueryFragments();
        String string = this.m_sqlFragments[0].trim().toLowerCase();
        String[] stringArray2 = string.split(" ");
        if (stringArray2.length >= 2 && stringArray2[0].startsWith("show")) {
            if (stringArray2[1].startsWith("encryption")) {
                this.getEncryptionStatus();
            } else {
                if (!stringArray2[1].startsWith("cacerts")) throw new FMSQLException("Syntax error: SHOW statement", 27115);
                this.showCaCerts();
            }
        } else {
            this.result = FM_API.execDirect(stringArray, this.m_binds, this.m_bindTypes, this);
        }
        if (this.useCursorFetch()) {
            Object[] objectArray = new Object[]{};
            String[] stringArray3 = new String[]{};
            String[] stringArray4 = new String[]{"open " + this.m_cursorName};
            FM_API.execDirect(stringArray4, objectArray, stringArray3, this);
            stringArray4[0] = "fetch first from " + this.m_cursorName;
            this.result = FM_API.execDirect(stringArray4, objectArray, stringArray3, this);
        }
        if (this.isFunction) {
            if (!this.result.reallyResultSet()) {
                throw new FMSQLException("CallableStatement function was executed with nothing returned.", "02000", 27116);
            }
            if (!this.result.next()) {
                throw new FMSQLException("CallableStatement function was executed with nothing returned.", "02000", 27117);
            }
            this.callResult = this.result.getObject(1);
            int n = this.result.getMetaData().getColumnType(1);
            if (n != this.functionReturnType) {
                throw new FMSQLException("CallableStatement function was executed and the return was different than what was registered.", "42821", 27118);
            }
            this.result.close();
            if (!Driver.logInfo) return true;
            Driver.info("stmt.execDirect elapsed (ms): " + (System.currentTimeMillis() - l));
            return true;
        }
        if (Driver.logInfo) {
            Driver.info("stmt.execDirect elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        if (this.result == null) return false;
        if (!this.result.reallyResultSet()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute() throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.execute();");
        }
        long l = System.currentTimeMillis();
        if (this.isClosed) {
            throw new FMSQLException("Statement has been closed.", 27119);
        }
        if (this.isFunction && !this.returnTypeSet) {
            throw new FMSQLException("CallableStatement function was declared but no call to registerOutParameterwas made.", "2F003", 27120);
        }
        if (this.isFunction) {
            this.m_binds[0] = "";
            this.m_bindTypes[0] = FM_TEXT;
        }
        if (this.result != null && !this.isPrepared && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        for (int i = 0; i < this.m_binds.length; ++i) {
            if (this.m_binds[i] != null) continue;
            throw new FMSQLException("Invalid parameter binding(s).", 27121);
        }
        String string = this.m_sqlFragments[0].trim().toLowerCase();
        String[] stringArray = string.split(" ");
        if (stringArray.length >= 2 && stringArray[0].startsWith("show")) {
            if (stringArray[1].startsWith("encryption")) {
                this.getEncryptionStatus();
            } else {
                if (!stringArray[1].startsWith("cacerts")) throw new FMSQLException("Syntax error: SHOW statement", 27115);
                this.showCaCerts();
            }
        } else {
            try {
                if (this.result == null) {
                    this.result = FM_API.execute(this.commandID, this.m_binds, this.m_bindTypes, this);
                } else {
                    FM_API.execute(this.commandID, this.m_binds, this.m_bindTypes, this.result);
                }
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), 27115);
            }
        }
        if (this.isFunction) {
            if (!this.result.reallyResultSet()) {
                throw new FMSQLException("CallableStatement function was executed with nothing returned.", "02000", 27122);
            }
            if (!this.result.next()) {
                throw new FMSQLException("CallableStatement function was executed with nothing returned.", "02000", 27123);
            }
            this.callResult = this.result.getObject(1);
            int n = this.result.getMetaData().getColumnType(1);
            if (n != this.functionReturnType) {
                throw new FMSQLException("CallableStatement function was executed and the return was different than what was registered.", "42821", 27124);
            }
            this.result.close();
            if (!Driver.logInfo) return true;
            Driver.info("stmt.execute elapsed (ms): " + (System.currentTimeMillis() - l));
            return true;
        }
        if (Driver.logInfo) {
            Driver.info("stmt.execute elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        if (this.result == null) return false;
        if (!this.result.reallyResultSet()) return false;
        return true;
    }

    public ResultSet getTables(String string) throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.getTables(\"" + string + "\");");
        }
        long l = System.currentTimeMillis();
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = FM_API.getTables(string, this);
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new FMSQLException("No results were returned by the query.", "02000", 27125);
        }
        if (Driver.logInfo) {
            Driver.info("stmt.getTables elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        return (ResultSet)((Object)this.result);
    }

    public ResultSet getColumns(String string, String string2) throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.getColumns(\"" + string + "\", \"" + string2 + "\");");
        }
        long l = System.currentTimeMillis();
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = FM_API.getColumns(string, string2, this);
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new FMSQLException("No results were returned by the query.", "02000", 27126);
        }
        if (Driver.logInfo) {
            Driver.info("stmt.getColumns elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        return (ResultSet)((Object)this.result);
    }

    public ResultSet getPrimaryKeys(String string) throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.getPrimaryKeys(\"" + string + "\");");
        }
        long l = System.currentTimeMillis();
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = FM_API.getPrimaryKeys(string, this);
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new FMSQLException("No results were returned by the query.", "02000", 27127);
        }
        if (Driver.logInfo) {
            Driver.info("stmt.getPrimaryKeys elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        return (ResultSet)((Object)this.result);
    }

    public ResultSet getIndexInfo(String string) throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.getIndexInfo(\"" + string + "\");");
        }
        long l = System.currentTimeMillis();
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = FM_API.getIndexInfo(string, this);
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new FMSQLException("No results were returned by the query.", "02000", 27128);
        }
        if (Driver.logInfo) {
            Driver.info("stmt.getIndexInfo elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        return (ResultSet)((Object)this.result);
    }

    public ResultSet getColumnPrivileges(String string, String string2) throws SQLException {
        ResultSet resultSet;
        if (Driver.logInfo) {
            Driver.info("stmt.getColumnPrivileges(\"" + string + "\");");
        }
        long l = System.currentTimeMillis();
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = FM_API.getColumnPrivileges(string, string2, this);
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new FMSQLException("No results were returned by the query.", "02000", 27129);
        }
        if (Driver.logInfo) {
            Driver.info("stmt.getColumnPrivileges elapsed (ms): " + (System.currentTimeMillis() - l));
        }
        return (ResultSet)((Object)this.result);
    }

    public void setCursorName(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setCursorName(\"" + string + "\");");
        }
        this.connection.setCursorName(string);
    }

    public int getUpdateCount() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int updateCount = stmt.getUpdateCount();");
        }
        if (this.result == null) {
            return -1;
        }
        if (this.isFunction) {
            return 1;
        }
        if (this.result.reallyResultSet()) {
            return -1;
        }
        return this.result.getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl;
        if (Driver.logInfo) {
            Driver.info("boolean moreResults = stmt.getMoreResults();");
        }
        this.result = (BaseResultSet)((Object)this.result.getNext());
        boolean bl2 = bl = this.result != null && this.result.reallyResultSet();
        if (Driver.logInfo) {
            Driver.info("// moreResults: " + bl);
        }
        return bl;
    }

    public String getResultStatusString() {
        if (Driver.logInfo) {
            Driver.info("String resultStatusString = stmt.getResultStatusString();");
        }
        if (this.result == null) {
            return null;
        }
        return this.result.getStatusString();
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int maxRows = stmt.getMaxRows();");
        }
        if (Driver.logInfo) {
            Driver.info("// maxRows: " + this.maxrows);
        }
        return this.maxrows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setMaxRows(" + n + ");");
        }
        if (n < 0) {
            throw new FMSQLException("Maximum number of rows must be a value greater than or equal to 0.", 27130);
        }
        this.maxrows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setEscapeProcessing(" + bl + ");");
        }
        this.replaceProcessingEnabled = bl;
    }

    public int getQueryTimeout() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int queryTimeout = stmt.getQueryTimeout();");
        }
        if (Driver.logInfo) {
            Driver.info("// queryTimeout: " + this.timeout);
        }
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setQueryTimeout(" + n + ");");
        }
        if (n < 0) {
            throw new FMSQLException("Query timeout must be a value greater than or equal to 0.", 27131);
        }
        this.timeout = n;
    }

    @Override
    public void addWarning(String string) {
        if (Driver.logInfo) {
            Driver.info("stmt.addWarning(\"" + string + "\");");
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(string));
        } else {
            this.warnings = new SQLWarning(string);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("SQLWarning warnings = stmt.getWarnings();");
        }
        return this.warnings;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int maxFieldSize = stmt.getMaxFieldSize();");
        }
        if (Driver.logInfo) {
            Driver.info("// maxFieldSize: " + this.maxfieldSize);
        }
        return this.maxfieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setMaxFieldSize(\"" + n + "\");");
        }
        if (n < 0) {
            throw new FMSQLException("The maximum field size must be a value greater than or equal to 0.", 27132);
        }
        this.maxfieldSize = n;
    }

    public void clearWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.clearWarnings();");
        }
        this.warnings = null;
    }

    public void cancel() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.cancel();");
        }
        throw new FMSQLException("This method is not yet implemented.", "0A000", 27133);
    }

    public ResultSet getResultSet() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("ResultSet resultSet = stmt.getResultSet();");
        }
        if (this.result != null && this.result.reallyResultSet()) {
            return (ResultSet)((Object)this.result);
        }
        return null;
    }

    @Override
    public int getCommandID() {
        return this.commandID;
    }

    @Override
    public void setCommandID(int n) {
        this.commandID = n;
    }

    @Override
    public boolean getIsPrepared() {
        return this.isPrepared;
    }

    @Override
    public void close() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.close();");
        }
        if (this.isClosed) {
            return;
        }
        boolean bl = false;
        ResultSet resultSet = this.getResultSet();
        if (this.isPrepared) {
            bl = true;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (bl) {
            FM_API.endStatement(this.commandID, this);
        }
        this.deallocateQuery();
        this.result = null;
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (Driver.logInfo) {
            Driver.info("stmt.finalize();");
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            if (Driver.logInfo) {
                Driver.info("--> caught SQLException");
            }
        }
        catch (Exception exception) {
            if (Driver.logInfo) {
                Driver.info("--> caught Exception");
            }
        }
        finally {
            super.finalize();
        }
    }

    protected String replaceProcessing(String string) {
        if (this.replaceProcessingEnabled) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            int n2 = -1;
            int n3 = string.length();
            while (++n2 < n3) {
                char c = string.charAt(n2);
                switch (n) {
                    case 0: {
                        if (c == '\'') {
                            n = 1;
                        } else if (c == '{' && n2 + 1 < n3) {
                            int n4;
                            char c2 = string.charAt(n4);
                            for (n4 = n2 + 1; n4 < n3; ++n4) {
                                c2 = string.charAt(n4);
                                if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
                                    continue;
                                }
                                if (c2 != 'd' && c2 != 'D' && c2 != 't' && c2 != 'T') break;
                                n2 = n4;
                                break;
                            }
                            if (c2 == 'd' || c2 == 'D') {
                                n = 3;
                                stringBuffer.append("DATE");
                                break;
                            }
                            if (c2 == 't' || c2 == 'T') {
                                n = 3;
                                if (n2 + 1 < n3 && (string.charAt(n2 + 1) == 's' || string.charAt(n2 + 1) == 'S')) {
                                    stringBuffer.append("TIMESTAMP");
                                    ++n2;
                                    break;
                                }
                                stringBuffer.append("TIME");
                                break;
                            }
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case 1: {
                        if (c == '\'') {
                            n = 0;
                        } else if (c == '\\') {
                            n = 2;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case 2: {
                        n = 1;
                        stringBuffer.append(c);
                        break;
                    }
                    case 3: {
                        if (c == '}') {
                            n = 0;
                            break;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            if (stringBuffer.toString().indexOf(123) >= 0) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Pattern pattern = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})[ \n\r\t]*[}]");
                Matcher matcher = pattern.matcher(stringBuffer.toString());
                while (matcher.find()) {
                    String string2 = "DATE '" + matcher.group(3) + "-" + matcher.group(1) + "-" + matcher.group(2) + "'";
                    stringBuffer.replace(matcher.start(), matcher.end(), string2);
                }
                Pattern pattern2 = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2})/([0-9]{1,2})/([8-9][0-9])[ \n\r\t]*[}]");
                Matcher matcher2 = pattern2.matcher(stringBuffer.toString());
                while (matcher2.find()) {
                    object6 = "DATE '19" + matcher2.group(3) + "-" + matcher2.group(1) + "-" + matcher2.group(2) + "'";
                    stringBuffer.replace(matcher2.start(), matcher2.end(), (String)object6);
                }
                object6 = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2})/([0-9]{1,2})/([0-7][0-9])[ \n\r\t]*[}]");
                Matcher matcher3 = ((Pattern)object6).matcher(stringBuffer.toString());
                while (matcher3.find()) {
                    object5 = "DATE '20" + matcher3.group(3) + "-" + matcher3.group(1) + "-" + matcher3.group(2) + "'";
                    stringBuffer.replace(matcher3.start(), matcher3.end(), (String)object5);
                }
                object5 = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2}):([0-9]{1,2})(:[0-9]{1,2})?[ \n\r\t]*[}]");
                Matcher matcher4 = ((Pattern)object5).matcher(stringBuffer.toString());
                while (matcher4.find()) {
                    object4 = "TIME '" + matcher4.group(1) + ":" + matcher4.group(2) + matcher4.group(3) + "'";
                    stringBuffer.replace(matcher4.start(), matcher4.end(), (String)object4);
                }
                object4 = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})[ \n\r\t]*([0-9]{1,2}):([0-9]{1,2})(:[0-9]{1,2})?[ \n\r\t]*[}]");
                Matcher matcher5 = ((Pattern)object4).matcher(stringBuffer.toString());
                while (matcher5.find()) {
                    object3 = "TIMESTAMP '" + matcher5.group(3) + "-" + matcher5.group(1) + "-" + matcher5.group(2) + " " + matcher5.group(4) + ":" + matcher5.group(5) + matcher5.group(6) + "'";
                    stringBuffer.replace(matcher5.start(), matcher5.end(), (String)object3);
                }
                object3 = Pattern.compile("[{][ \n\r\t]*([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})[ \n\r\t]*([0-9]{1,2}):([0-9]{1,2})(:[0-9]{1,2})?[ \n\r\t]*[}]");
                Matcher matcher6 = ((Pattern)object3).matcher(stringBuffer.toString());
                while (matcher6.find()) {
                    object2 = "TIMESTAMP '" + matcher6.group(1) + "-" + matcher6.group(2) + "-" + matcher6.group(3) + " " + matcher6.group(4) + ":" + matcher6.group(5) + matcher6.group(6) + "'";
                    stringBuffer.replace(matcher6.start(), matcher6.end(), (String)object2);
                }
                object2 = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2})/([0-9]{1,2})/([8-9][0-9])[ \n\r\t]*([0-9]{1,2}):([0-9]{1,2})(:[0-9]{1,2})?[ \n\r\t]*[}]");
                Matcher matcher7 = ((Pattern)object2).matcher(stringBuffer.toString());
                while (matcher7.find()) {
                    object = "TIMESTAMP '19" + matcher7.group(3) + "-" + matcher7.group(1) + "-" + matcher7.group(2) + " " + matcher7.group(4) + ":" + matcher7.group(5) + matcher7.group(6) + "'";
                    stringBuffer.replace(matcher7.start(), matcher7.end(), (String)object);
                }
                object = Pattern.compile("[{][ \n\r\t]*([0-9]{1,2})/([0-9]{1,2})/([0-7][0-9])[ \n\r\t]*([0-9]{1,2}):([0-9]{1,2})(:[0-9]{1,2})?[ \n\r\t]*[}]");
                Matcher matcher8 = ((Pattern)object).matcher(stringBuffer.toString());
                while (matcher8.find()) {
                    String string3 = "TIMESTAMP '20" + matcher8.group(3) + "-" + matcher8.group(1) + "-" + matcher8.group(2) + " " + matcher8.group(4) + ":" + matcher8.group(5) + matcher8.group(6) + "'";
                    stringBuffer.replace(matcher8.start(), matcher8.end(), string3);
                }
                return stringBuffer.toString();
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void setNull(int n, int n2) throws SQLException {
        String string;
        if (Driver.logInfo) {
            Driver.info("stmt.setNull(" + n + ", " + n2 + ");");
        }
        switch (n2) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                string = FM_INTEGER;
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = FM_NUMERIC;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = FM_TEXT;
                break;
            }
            case 91: {
                string = FM_DATE;
                break;
            }
            case 92: {
                string = FM_TIME;
                break;
            }
            case 93: {
                string = FM_TIMESTAMP;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = FM_BLOB;
                break;
            }
            case 1111: {
                string = FM_TEXT;
                break;
            }
            default: {
                string = FM_TEXT;
            }
        }
        this.bind(n, "null", string);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setBoolean(" + n + ", " + bl + ");");
        }
        this.bind(n, bl ? "1" : "0", FM_INTEGER);
    }

    public void setByte(int n, byte by) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setByte(" + n + ", " + by + ");");
        }
        this.bind(n, Integer.toString(by), FM_INTEGER);
    }

    public void setShort(int n, short s) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setShort(" + n + ", " + s + ");");
        }
        this.bind(n, Integer.toString(s), FM_INTEGER);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setInt(" + n + ", " + n2 + ");");
        }
        this.bind(n, Integer.toString(n2), FM_INTEGER);
    }

    public void setLong(int n, long l) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setLong(" + n + ", " + l + ");");
        }
        this.bind(n, Long.toString(l), FM_NUMERIC);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setFloat(" + n + ", " + f + ");");
        }
        this.bind(n, Float.toString(f), FM_NUMERIC);
    }

    public void setDouble(int n, double d) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setDouble(" + n + ", " + d + ");");
        }
        this.bind(n, Double.toString(d), FM_NUMERIC);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setBigDecimal(" + n + ", " + bigDecimal + ");");
        }
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.bind(n, bigDecimal.toString(), FM_NUMERIC);
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setString(" + n + ", \"" + string + "\");");
        }
        this.setString(n, string, FM_TEXT);
    }

    public void setString(int n, String string, String string2) throws SQLException {
        if (string == null) {
            this.setNull(n, 12);
        } else {
            this.bind(n, string, string2);
        }
    }

    private void escapeString(String string, StringBuffer stringBuffer) {
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block4;
                }
                case '\u0000': {
                    throw new IllegalArgumentException("\\0 not allowed");
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setBytes(" + n + ", ...);");
        }
        if (null == byArray) {
            this.setNull(n, -3);
        } else {
            this.bind(n, byArray, FM_BLOB);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setDate(" + n + ", ...);");
        }
        if (null == date) {
            this.setNull(n, 91);
        } else {
            this.bind(n, date.toString(), FM_DATE);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setTime(" + n + ", ...);");
        }
        if (null == time) {
            this.setNull(n, 92);
        } else {
            this.bind(n, time.toString(), FM_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setTimestamp(" + n + ", ...);");
        }
        if (null == timestamp) {
            this.setNull(n, 93);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(42);
                int n2 = timestamp.getYear() + 1900;
                this.sbuf.append(n2);
                this.sbuf.append('-');
                int n3 = timestamp.getMonth() + 1;
                if (n3 < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(n3);
                this.sbuf.append('-');
                int n4 = timestamp.getDate();
                if (n4 < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(n4);
                this.sbuf.append(' ');
                int n5 = timestamp.getHours();
                if (n5 < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(n5);
                this.sbuf.append(':');
                int n6 = timestamp.getMinutes();
                if (n6 < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(n6);
                this.sbuf.append(':');
                int n7 = timestamp.getSeconds();
                if (n7 < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(n7);
                char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
                char[] cArray2 = Integer.toString(timestamp.getNanos()).toCharArray();
                System.arraycopy(cArray2, 0, cArray, cArray.length - cArray2.length, cArray2.length);
                this.sbuf.append('.');
                this.sbuf.append(cArray, 0, 6);
                this.bind(n, this.sbuf.toString(), FM_TIMESTAMP);
            }
        }
    }

    private void setCharacterStream(int n, InputStream inputStream, int n2, String string) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        try {
            int n3;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = inputStreamReader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.setString(n, new String(cArray, 0, n4), FM_TEXT);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FMSQLException(unsupportedEncodingException.getMessage(), 27161);
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), 27162);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setAsciiStream(" + n + ", ..., " + n2 + ");");
        }
        this.setCharacterStream(n, inputStream, n2, "ASCII");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setUnicodeStream(" + n + ", ..., " + n2 + ");");
        }
        this.setCharacterStream(n, inputStream, n2, "UTF-8");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setBinaryStream(" + n + ", ..., " + n2 + ");");
        }
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        this.bind(n, inputStream, FM_STREAM);
    }

    public void clearParameters() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.clearParameters();");
        }
        for (int i = 0; i < this.m_binds.length; ++i) {
            this.m_binds[i] = null;
            this.m_bindTypes[i] = null;
        }
    }

    private String numericValueOf(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "1" : "0";
        }
        if (object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Short || object instanceof Number || object instanceof Float) {
            return object.toString();
        }
        return new BigDecimal(object.toString()).toString();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setObject(" + n + ", ..., " + n2 + ", " + n3 + ");");
        }
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -6: 
            case 4: 
            case 5: {
                this.bind(n, this.numericValueOf(object), FM_INTEGER);
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.bind(n, this.numericValueOf(object), FM_NUMERIC);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                break;
            }
            case 91: {
                if (object instanceof Date) {
                    this.setDate(n, (Date)object);
                    break;
                }
                Date date = object instanceof java.util.Date ? new Date(((java.util.Date)object).getTime()) : this.dateFromString(object.toString());
                this.setDate(n, date);
                break;
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTime(n, (Time)object);
                    break;
                }
                Time time = object instanceof java.util.Date ? new Time(((java.util.Date)object).getTime()) : this.timeFromString(object.toString());
                this.setTime(n, time);
                break;
            }
            case 93: {
                if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                Timestamp timestamp = object instanceof java.util.Date ? new Timestamp(((java.util.Date)object).getTime()) : this.timestampFromString(object.toString());
                this.setTimestamp(n, timestamp);
                break;
            }
            case -7: {
                if (object instanceof Boolean) {
                    this.bind(n, (Boolean)object != false ? "1" : "0", FM_INTEGER);
                    break;
                }
                if (object instanceof String) {
                    this.bind(n, Boolean.valueOf(object.toString()) != false ? "1" : "0", FM_INTEGER);
                    break;
                }
                if (object instanceof Number) {
                    this.bind(n, ((Number)object).intValue() != 0 ? "1" : "0", FM_INTEGER);
                    break;
                }
                throw new FMSQLException("Invalid parameter type.", "07006", 27134);
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(n, object);
                break;
            }
            case 1111: {
                if (object instanceof FMobject) {
                    this.setString(n, ((FMobject)object).getValue(), ((FMobject)object).getType());
                    break;
                }
                throw new FMSQLException("Invalid parameter type.", "07006", 27135);
            }
            default: {
                throw new FMSQLException("Invalid parameter type.", "07006", 27136);
            }
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setObject(" + n + ", ..., " + n2 + ");");
        }
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.setObject(" + n + ", ...);");
        }
        if (object == null) {
            this.setNull(n, 1111);
            return;
        }
        if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof FMobject) {
            this.setString(n, ((FMobject)object).getValue(), FM_TEXT);
        } else {
            this.setString(n, object.toString(), FM_TEXT);
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.registerOutParameter(" + n + ", " + n2 + ");");
        }
        if (n != 1) {
            throw new FMSQLException("FileMaker does not support OUT or INOUT parameters.", "2F003", 27137);
        }
        if (!this.isFunction) {
            throw new FMSQLException("Statetment not allowed in function call.", "2F003", 27138);
        }
        this.functionReturnType = n2;
        this.testReturn = n2;
        if (this.functionReturnType == 1 || this.functionReturnType == -1) {
            this.testReturn = 12;
        } else if (this.functionReturnType == 6) {
            this.testReturn = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("stmt.registerOutParameter(" + n + ", " + n2 + ", " + n3 + ");");
        }
        this.registerOutParameter(n, n2);
    }

    public boolean wasNull() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("boolean isNull = stmt.wasNull();");
        }
        if (Driver.logInfo) {
            Driver.info("// isNull: " + (this.callResult == null));
        }
        return this.callResult == null;
    }

    public String getString(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String str = stmt.getString(" + n + ");");
        }
        this.checkIndex(n, 12, "String");
        if (Driver.logInfo) {
            Driver.info("// str: " + (String)this.callResult);
        }
        return (String)this.callResult;
    }

    public boolean getBoolean(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("boolean bool = stmt.getBoolean(" + n + ");");
        }
        this.checkIndex(n, -7, "Boolean");
        if (this.callResult == null) {
            return false;
        }
        if (Driver.logInfo) {
            Driver.info("// bool: " + (Boolean)this.callResult);
        }
        return (Boolean)this.callResult;
    }

    public byte getByte(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("byte byt = stmt.getByte(" + n + ");");
        }
        this.checkIndex(n, -6, "Byte");
        if (this.callResult == null) {
            return 0;
        }
        if (Driver.logInfo) {
            Driver.info("// byt: " + (byte)((Integer)this.callResult).intValue());
        }
        return (byte)((Integer)this.callResult).intValue();
    }

    public short getShort(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("short shrt = stmt.getShort(" + n + ");");
        }
        this.checkIndex(n, 5, "Short");
        if (this.callResult == null) {
            return 0;
        }
        if (Driver.logInfo) {
            Driver.info("// shrt: " + (short)((Integer)this.callResult).intValue());
        }
        return (short)((Integer)this.callResult).intValue();
    }

    public int getInt(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int intValue = stmt.getInt(" + n + ");");
        }
        this.checkIndex(n, 4, "Int");
        if (this.callResult == null) {
            return 0;
        }
        if (Driver.logInfo) {
            Driver.info("// intValue: " + (Integer)this.callResult);
        }
        return (Integer)this.callResult;
    }

    public long getLong(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("long longValue = stmt.getLong(" + n + ");");
        }
        this.checkIndex(n, -5, "Long");
        if (this.callResult == null) {
            return 0L;
        }
        if (Driver.logInfo) {
            Driver.info("// longValue: " + (Long)this.callResult);
        }
        return (Long)this.callResult;
    }

    public float getFloat(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("float floatValue = stmt.getFloat(" + n + ");");
        }
        this.checkIndex(n, 7, "Float");
        if (this.callResult == null) {
            return 0.0f;
        }
        if (Driver.logInfo) {
            Driver.info("// floatValue: " + ((Float)this.callResult).floatValue());
        }
        return ((Float)this.callResult).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("double doubleValue = stmt.getDouble(" + n + ");");
        }
        this.checkIndex(n, 8, "Double");
        if (this.callResult == null) {
            return 0.0;
        }
        if (Driver.logInfo) {
            Driver.info("// doubleValue: " + (Double)this.callResult);
        }
        return (Double)this.callResult;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("BigDecimal bigDecimal = stmt.getBigDecimal(" + n + ", " + n2 + ");");
        }
        this.checkIndex(n, 2, "BigDecimal");
        if (Driver.logInfo) {
            Driver.info("// bigDecimal: " + (BigDecimal)this.callResult);
        }
        return (BigDecimal)this.callResult;
    }

    public byte[] getBytes(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("byte[] bytes = stmt.getBytes(" + n + ");");
        }
        this.checkIndex(n, -3, -2, "Bytes");
        return (byte[])this.callResult;
    }

    public Date getDate(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("Date date = stmt.getDate(" + n + ");");
        }
        this.checkIndex(n, 91, "Date");
        return (Date)this.callResult;
    }

    public Time getTime(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("Time time = stmt.getTime(" + n + ");");
        }
        this.checkIndex(n, 92, "Time");
        return (Time)this.callResult;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("Timestamp timestamp = stmt.getTimestamp(" + n + ");");
        }
        this.checkIndex(n, 93, "Timestamp");
        return (Timestamp)this.callResult;
    }

    public Object getObject(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("Object object = stmt.getObject(" + n + ");");
        }
        this.checkIndex(n);
        return this.callResult;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int concurrency = stmt.getResultSetConcurrency();");
        }
        if (Driver.logInfo) {
            Driver.info("// concurrency: 0");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.m_sqlFragments == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            for (int i = 0; i < this.m_binds.length; ++i) {
                this.sbuf.append(this.m_sqlFragments[i]);
                if (this.m_binds[i] == null) {
                    this.sbuf.append('?');
                    continue;
                }
                this.sbuf.append(this.m_binds[i]);
            }
            this.sbuf.append(this.m_sqlFragments[this.m_binds.length]);
            return this.sbuf.toString();
        }
    }

    private void bind(int n, Object object, String string) throws SQLException {
        if (n < 1 || n > this.m_binds.length) {
            throw new FMSQLException("Parameter index out of range.", "22023", 27139);
        }
        if (n == 1 && this.isFunction) {
            throw new FMSQLException("Improper binding of parameter.", 27140);
        }
        this.m_binds[n - 1] = object;
        this.m_bindTypes[n - 1] = string;
    }

    private String modifyJdbcCall(String string) throws SQLException {
        if (!string.trim().startsWith("{")) {
            return string;
        }
        this.originalSql = string;
        String string2 = string;
        int n = string2.indexOf("=");
        boolean bl = true;
        if (n > -1) {
            this.isFunction = true;
            boolean bl2 = bl = string2.indexOf("?") < n;
        }
        if ((string2 = string2.trim()).startsWith("{") && string2.endsWith("}")) {
            string2 = string2.substring(1, string2.length() - 1);
        } else {
            bl = false;
        }
        n = string2.indexOf("call");
        if (n == -1 || !bl) {
            throw new FMSQLException("Malformed statement", "2F003", 27141);
        }
        string2 = string2.replace('{', ' ');
        string2 = string2.replace('}', ' ');
        string2 = string2.replace(';', ' ');
        string2 = (this.isFunction ? "?" : "") + string2.substring(n + 4);
        string2 = "select// from " + string2 + " as " + RESULT_ALIAS + ";";
        return string2;
    }

    protected void checkIndex(int n, int n2, int n3, String string) throws SQLException {
        this.checkIndex(n);
        if (n2 != this.testReturn && n3 != this.testReturn) {
            throw new FMSQLException("get() function type does not match registered type", "2200G", 27142);
        }
    }

    protected void checkIndex(int n, int n2, String string) throws SQLException {
        this.checkIndex(n);
        if (n2 != this.testReturn) {
            throw new FMSQLException("get() function type does not match registered type", "2200G", 27143);
        }
    }

    private void checkIndex(int n) throws SQLException {
        if (!this.isFunction) {
            throw new FMSQLException("CallableStatement function was declared but no call to registerOutParameter was made.", "2F003", 27144);
        }
        if (n != 1) {
            throw new FMSQLException("FileMaker does not support OUT or INOUT parameters.", "2F003", 27145);
        }
    }

    public void setUseServerPrepare(boolean bl) throws SQLException {
        if (this.m_useServerPrepare != bl) {
            this.deallocateQuery();
        }
        this.m_useServerPrepare = bl;
    }

    public boolean isUseServerPrepare() {
        return this.m_useServerPrepare;
    }

    private Date dateFromString(String string) throws SQLException {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        int n2 = string.indexOf(43) == -1 ? string.lastIndexOf("-") : string.indexOf(43);
        try {
            n = n2 > 7 ? n2 : string.length();
            l = Date.valueOf(string.substring(0, n)).getTime();
        }
        catch (Exception exception) {
            throw new FMSQLException("The date does not match the required format.", "22007", 27146);
        }
        n = 0;
        if (n2 > 7 && n2 + 3 == string.length()) {
            n = Integer.parseInt(string.substring(n2 + 1, string.length()));
            l2 = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(l))) {
                l2 += 3600000L;
            }
            if (string.charAt(n2) == '+') {
                n *= -1;
            }
        }
        l = l + (long)(n * 60 * 60 * 1000) + l2;
        return new Date(l);
    }

    private Time timeFromString(String string) throws SQLException {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        int n2 = string.indexOf(43) == -1 ? string.lastIndexOf("-") : string.indexOf(43);
        try {
            n = n2 == -1 ? string.length() : n2;
            l = Time.valueOf(string.substring(0, n)).getTime();
        }
        catch (Exception exception) {
            throw new FMSQLException("The time does not match the required format.", "22007", 27147);
        }
        n = 0;
        if (n2 != -1 && n2 + 3 == string.length()) {
            n = Integer.parseInt(string.substring(n2 + 1, string.length()));
            l2 = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(l))) {
                l2 += 3600000L;
            }
            if (string.charAt(n2) == '+') {
                n *= -1;
            }
        }
        l = l + (long)(n * 60 * 60 * 1000) + l2;
        return new Time(l);
    }

    private Timestamp timestampFromString(String string) throws SQLException {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        int n3 = string.indexOf(43) == -1 ? string.lastIndexOf("-") : string.indexOf(43);
        int n4 = string.indexOf(".");
        try {
            n = n4 != -1 ? n4 : (n3 > 8 ? n3 : string.length());
            l = Timestamp.valueOf(string.substring(0, n)).getTime();
        }
        catch (Exception exception) {
            throw new FMSQLException("The timestamp does not match the required format.", "22007", 27148);
        }
        n = 0;
        if (n4 != -1) {
            int n5 = n3 > 8 ? n3 : string.length();
            n2 = Integer.parseInt(string.substring(n4 + 1, n5));
            int n6 = 8 - (n5 - 1 - (n4 + 1));
            for (int i = 0; i < n6; ++i) {
                n2 *= 10;
            }
        }
        if (n3 > 8 && n3 + 3 == string.length()) {
            n = Integer.parseInt(string.substring(n3 + 1, string.length()));
            l2 = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(l))) {
                l2 += 3600000L;
            }
            if (string.charAt(n3) == '+') {
                n *= -1;
            }
        }
        l = l + (long)(n * 60 * 60 * 1000) + l2;
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n2);
        return timestamp;
    }
}

