/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMColumnValue;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.MessageListItem;
import com.filemaker.jdbc.ProtocolMessage;
import java.util.Vector;

public class FMRowResponse
extends ProtocolMessage {
    public static final short CMD_FM_ROW_RESPONSE = 87;
    private int commandID;
    private long rowNumber;
    private int columnCount;
    private Vector columns = new Vector();

    public FMRowResponse(int n, long l) {
        super(new MessageListItem(87));
        this.columnCount = 0;
        this.addParameter16(n);
        this.addParameter64(l);
        this.addParameter16(this.columnCount);
    }

    public FMRowResponse(byte[] byArray) {
        super(byArray);
    }

    public short addColumn(int n, short s, long l, String string) {
        this.addParameter16(n);
        this.addParameter8(s);
        this.addParameter64(l);
        this.addParameter(string);
        this.columns.addElement(new FMColumnValue(n, s, l, string.getBytes()));
        this.columnCount = this.columns.size();
        return 0;
    }

    @Override
    public boolean extract() {
        this.commandID = this.getParameter16();
        this.rowNumber = this.getParameter64();
        this.columnCount = this.getParameter16();
        for (int i = 0; i < this.columnCount; ++i) {
            Object object;
            int n = this.getParameter16();
            short s = this.getParameter8();
            long l = this.getParameter64();
            if (l < 65535L) {
                object = new byte[(int)l];
                this.getParameter((byte[])object);
                this.columns.addElement(new FMColumnValue(n, s, l, (byte[])object));
                continue;
            }
            object = new Vector();
            int n2 = this.getParameterAsList(l, (Vector)object);
            this.columns.addElement(new FMColumnValue(n, s, l, (Vector)object, n2));
        }
        this.extracted = true;
        return true;
    }

    public int getCommandID() {
        if (!this.extracted) {
            this.extract();
        }
        return this.commandID;
    }

    public long getRowNumber() {
        if (!this.extracted) {
            this.extract();
        }
        return this.rowNumber;
    }

    public int getColumnCount() {
        if (!this.extracted) {
            this.extract();
        }
        return this.columnCount;
    }

    public Vector getColumns() {
        if (!this.extracted) {
            this.extract();
        }
        return this.columns;
    }

    @Override
    public boolean send(FMStream fMStream) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(0);
        messageBlock.setItemCount(15, this.columnCount);
        return super.send(fMStream);
    }
}

