/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.MessageBlock;
import java.util.Vector;

public class FMColumnValue {
    public int columnNumber;
    public short isNull;
    public long totalFieldLength;
    public byte[] byteValue = null;
    public Vector vectorValue = null;
    public int startByteIndex = 0;
    public boolean isVector = false;

    public FMColumnValue(int n, short s, long l, byte[] byArray) {
        this.columnNumber = n;
        this.isNull = s;
        this.totalFieldLength = l;
        this.byteValue = byArray;
        this.isVector = false;
    }

    public FMColumnValue(int n, short s, long l, Vector vector, int n2) {
        this.columnNumber = n;
        this.isNull = s;
        this.totalFieldLength = l;
        this.vectorValue = vector;
        this.startByteIndex = n2;
        this.isVector = true;
    }

    public byte[] getValue() {
        if (!this.isVector) {
            return this.byteValue;
        }
        if (this.byteValue == null) {
            this.byteValue = new byte[(int)this.totalFieldLength];
            this.getParameter(this.byteValue);
        }
        return this.byteValue;
    }

    public boolean getParameter(byte[] byArray) {
        boolean bl = true;
        int n = 0;
        long l = byArray.length;
        MessageBlock messageBlock = (MessageBlock)this.vectorValue.get(n);
        long l2 = messageBlock.getParameter(byArray, 0L);
        if (l2 > 0L) {
            bl = false;
        }
        while (!bl) {
            long l3 = l - l2;
            if (++n < this.vectorValue.size()) {
                messageBlock = (MessageBlock)this.vectorValue.get(n);
                l2 = messageBlock.getParameter(byArray, l3);
                if (l2 > 0L) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        return bl;
    }

    public State getStartState() {
        State state = new State();
        state.currentBlock = 0;
        state.buffer = new byte[65535];
        if (state.currentBlock < this.vectorValue.size()) {
            MessageBlock messageBlock = (MessageBlock)this.vectorValue.get(state.currentBlock);
        }
        return state;
    }

    public boolean getNextBlock(State state) {
        if (state.currentBlock >= this.vectorValue.size()) {
            return true;
        }
        MessageBlock messageBlock = (MessageBlock)this.vectorValue.get(state.currentBlock);
        int n = messageBlock.byteIndex;
        messageBlock.getParameter(state.buffer, 0L);
        state.bytesRemaining = messageBlock.byteIndex - n - 4;
        messageBlock.byteIndex = n;
        return false;
    }

    public class State {
        public int currentBlock = 0;
        public long bytesRemaining = 0L;
        public int position = 0;
        public byte[] buffer;
    }
}

