/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMSQLException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class FMStream {
    public static final int VerificationFailureNone = 0;
    public static final int VerificationFailureWarning = 1;
    public static final int VerificationFailureError = 2;
    public static final int VerificationLevelNone = 0;
    public static final int VerificationLevelCertificate = 1;
    public static final int VerificationLevelName = 2;
    public static final int VerificationLevelFull = 3;
    public String host;
    public int port;
    public Socket connection;
    public SocketFactory sslFactory;
    public InputStream fm_input;
    public String sslSubject = new String();
    public String sslAlternateNames = new String();
    public String sslStatus = new String();
    public String certExpDate = new String();
    public String issuerName = new String();
    public String intermediateName = new String();
    public String intermediateIssuer = new String();
    public String intermediateExpDate = new String();
    public BufferedOutputStream fm_output;
    public boolean isLocalListener = false;
    public String encryptionMethod = new String();
    public X509Certificate[] caCerts = null;
    private byte[] byte_buf = new byte[65536];
    private final byte[] _int8buf;
    private final byte[] _int4buf;
    private final byte[] _int2buf;
    private Cipher decryptCipher;
    private Cipher encryptCipher;
    private boolean doEncrypt;
    static int verificationLevel;
    static int verificationFailureType;
    static String verificationHost;
    static String verificationWarning;

    public FMStream(String string, int n, int n2, int n3) throws Exception {
        this.host = string;
        this.port = n;
        this.connection = new Socket(this.host, this.port);
        if (this.connection.getLocalAddress().equals(this.connection.getInetAddress())) {
            this.doEncrypt = false;
            this.isLocalListener = true;
        } else {
            this.doEncrypt = true;
            this.encryptionMethod = "AES-128";
            this.isLocalListener = false;
        }
        this._int2buf = new byte[2];
        this._int4buf = new byte[4];
        this._int8buf = new byte[8];
        this.connection.setSoTimeout(n3);
        this.connection.setTcpNoDelay(true);
        this.fm_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.fm_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        byte[] byArray = new byte[]{-61, 87, -86, -31, 27, 69, -73, -80, -94, -57, -67, 40, -88, -36, -103, -6};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        this.decryptCipher = Cipher.getInstance("AES/ECB/NoPadding");
        this.decryptCipher.init(2, secretKeySpec);
        this.encryptCipher = Cipher.getInstance("AES/ECB/NoPadding");
        this.encryptCipher.init(1, secretKeySpec);
    }

    static X509TrustManager getSystemDefaultTrustManager() {
        X509TrustManager x509TrustManager = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(System.getProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts"), "changeit".toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagerArray.length; ++i) {
                if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                x509TrustManager = (X509TrustManager)trustManagerArray[i];
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return x509TrustManager;
    }

    public static String buildSubjectString(String string) {
        String[] stringArray;
        String string2 = new String();
        String string3 = string.replaceAll("\\\\,", ";");
        for (String string4 : stringArray = string3.split(",")) {
            String[] stringArray2;
            if (!string4.contains("CN=") && !string4.contains("O=") && !string4.contains("OU=") && !string4.contains("L=") && !string4.contains("ST=") && !string4.contains("C=") || (stringArray2 = string4.trim().split("="))[1] == null) continue;
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append("/");
            stringBuilder.append(stringArray2[0].trim());
            stringBuilder.append("=");
            stringBuilder.append(stringArray2[1].trim().replaceAll(";", ","));
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static String getCertEntry(X500Principal x500Principal, String string) {
        String[] stringArray;
        String string2 = new String("");
        String string3 = x500Principal.getName();
        for (String string4 : stringArray = string3.split(",")) {
            String[] stringArray2;
            if (!string4.contains(string) || (stringArray2 = string4.trim().split("="))[1] == null) continue;
            string2 = stringArray2[1].trim();
            break;
        }
        return string2;
    }

    public static List<String> getAlternativeNames(X509Certificate x509Certificate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return Collections.emptyList();
            }
            for (List<?> list : collection) {
                Integer n = (Integer)list.get(0);
                if (n != 0 && n != 2) continue;
                try {
                    if (!(list.toArray()[1] instanceof String)) continue;
                    arrayList.add((String)list.toArray()[1]);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    static boolean checkHostMatch(String string, String string2) {
        boolean bl = false;
        if (string2.startsWith("*.")) {
            String string3;
            String string4 = string2.substring(1);
            int n = string4.length();
            int n2 = string.length();
            if (n2 >= n && string4.equalsIgnoreCase(string3 = string.substring(n2 - n))) {
                bl = true;
            }
        } else if (string2.equalsIgnoreCase(string)) {
            bl = true;
        }
        return bl;
    }

    public synchronized void establishSSL(boolean bl, int n, int n2) throws Exception {
        Object object;
        Comparable<StringBuilder> comparable;
        Object object2;
        X500Principal x500Principal;
        X500Principal x500Principal2;
        Certificate certificate;
        String[] stringArray;
        Object[] objectArray;
        String[] stringArray2;
        this.caCerts = null;
        verificationLevel = n;
        verificationFailureType = n2;
        verificationHost = this.host;
        verificationWarning = "";
        this.sslStatus = new String("OK");
        this.sslAlternateNames = new String("");
        boolean bl2 = false;
        String string = System.getProperties().getProperty("javax.net.ssl.trustStore");
        if (string != null) {
            bl2 = true;
        }
        if (bl2 && verificationFailureType != 0 && verificationLevel != 0) {
            this.sslFactory = SSLSocketFactory.getDefault();
        } else {
            stringArray2 = FMStream.getSystemDefaultTrustManager();
            if (stringArray2 == null && verificationFailureType != 0 && (verificationLevel == 1 || verificationLevel == 3)) {
                throw new FMSQLException("Could not access system default trust store, specify preferred trust store as javax.net.ssl.trustStore property", "08S01", 27006);
            }
            objectArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    X509TrustManager x509TrustManager = FMStream.getSystemDefaultTrustManager();
                    if (x509TrustManager != null) {
                        FMStream.this.caCerts = x509TrustManager.getAcceptedIssuers();
                    }
                    return FMStream.this.caCerts;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    boolean bl;
                    List<String> list;
                    String string2;
                    block14: {
                        Object object;
                        string2 = "";
                        list = null;
                        bl = false;
                        if (x509CertificateArray.length > 0) {
                            object = x509CertificateArray[0];
                            X500Principal x500Principal = ((X509Certificate)object).getSubjectX500Principal();
                            string2 = FMStream.getCertEntry(x500Principal, "CN=");
                            list = FMStream.getAlternativeNames((X509Certificate)object);
                        }
                        if ((object = FMStream.getSystemDefaultTrustManager()) != null) {
                            try {
                                object.checkServerTrusted(x509CertificateArray, string);
                            }
                            catch (CertificateException certificateException) {
                                if (string2.equalsIgnoreCase("FMI Default Certificate")) break block14;
                                FMStream.this.sslStatus = certificateException.getMessage();
                                if (verificationLevel != 1 && verificationLevel != 3) break block14;
                                bl = true;
                                if (verificationFailureType == 1) {
                                    verificationWarning = certificateException.getMessage();
                                    bl = true;
                                }
                                if (verificationFailureType != 2) break block14;
                                throw certificateException;
                            }
                        }
                    }
                    if (!bl) {
                        Object object;
                        boolean bl2 = FMStream.checkHostMatch(verificationHost, string2);
                        if (!bl2) {
                            String string3;
                            object = list.iterator();
                            while (object.hasNext() && !(bl2 = FMStream.checkHostMatch(verificationHost, string3 = object.next()))) {
                            }
                        }
                        if (!bl2) {
                            object = new String("SSL certificate common name does not match host name");
                            if (FMStream.this.sslStatus.equalsIgnoreCase("OK")) {
                                FMStream.this.sslStatus = object;
                            }
                            if (verificationLevel == 2 || verificationLevel == 3) {
                                if (verificationFailureType == 1) {
                                    verificationWarning = object;
                                } else if (verificationFailureType == 2) {
                                    throw new CertificateException((String)object);
                                }
                            }
                        }
                    }
                }
            }};
            try {
                stringArray = SSLContext.getInstance("TLS");
                stringArray.init(null, (TrustManager[])objectArray, new SecureRandom());
                this.sslFactory = stringArray.getSocketFactory();
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08S01", 27006);
            }
        }
        this.connection = ((SSLSocketFactory)this.sslFactory).createSocket(this.connection, this.host, this.port, true);
        stringArray2 = ((SSLSocket)this.connection).getSupportedProtocols();
        objectArray = ((SSLSocket)this.connection).getEnabledProtocols();
        stringArray = ((SSLSocket)this.connection).getSupportedCipherSuites();
        String[] stringArray3 = ((SSLSocket)this.connection).getEnabledCipherSuites();
        try {
            ((SSLSocket)this.connection).startHandshake();
        }
        catch (Exception exception) {
            String string2 = System.getProperty("java.version");
            int n3 = string2.indexOf(46);
            n3 = string2.indexOf(46, n3 + 1);
            double d = Double.parseDouble(string2.substring(0, n3));
            if (d < 1.8 && (!this.isLocalListener || this.isLocalListener && bl)) {
                throw new FMSQLException("Java 8 or later is required when connecting to FileMaker Server 16 or later", "08S01", 27006);
            }
            throw new FMSQLException(exception.getMessage(), "08S01", 27006);
        }
        this.doEncrypt = false;
        this.fm_input = new BufferedInputStream(this.connection.getInputStream(), 16384);
        this.fm_output = new BufferedOutputStream(this.connection.getOutputStream(), 16384);
        this.fm_output.flush();
        SSLSession sSLSession = ((SSLSocket)this.connection).getSession();
        Certificate[] certificateArray = sSLSession.getPeerCertificates();
        String string3 = sSLSession.getProtocol();
        String string4 = sSLSession.getCipherSuite();
        this.encryptionMethod = string4 + " " + string3;
        if (certificateArray.length > 0 && (certificate = certificateArray[0]) instanceof X509Certificate) {
            Object object3;
            x500Principal2 = ((X509Certificate)certificate).getSubjectX500Principal();
            this.sslSubject = FMStream.buildSubjectString(x500Principal2.getName());
            x500Principal = ((X509Certificate)certificate).getIssuerX500Principal();
            this.issuerName = FMStream.buildSubjectString(x500Principal.getName());
            object2 = FMStream.getAlternativeNames((X509Certificate)certificate);
            comparable = new StringBuilder("");
            object = object2.iterator();
            while (object.hasNext()) {
                object3 = (String)object.next();
                if (!((StringBuilder)comparable).toString().isEmpty()) {
                    ((StringBuilder)comparable).append(",");
                }
                ((StringBuilder)comparable).append((String)object3);
            }
            this.sslAlternateNames = ((StringBuilder)comparable).toString();
            object = ((X509Certificate)certificate).getNotAfter();
            object3 = Calendar.getInstance();
            ((Calendar)object3).setTime((Date)object);
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append(((Calendar)object3).get(1)).append("-").append(((Calendar)object3).get(2) + 1).append("-").append(((Calendar)object3).get(5));
            this.certExpDate = stringBuilder.toString();
        }
        if (certificateArray.length > 1 && (certificate = certificateArray[1]) instanceof X509Certificate) {
            x500Principal2 = ((X509Certificate)certificate).getSubjectX500Principal();
            this.intermediateName = FMStream.buildSubjectString(x500Principal2.getName());
            x500Principal = ((X509Certificate)certificate).getIssuerX500Principal();
            this.intermediateIssuer = FMStream.buildSubjectString(x500Principal.getName());
            object2 = ((X509Certificate)certificate).getNotAfter();
            comparable = Calendar.getInstance();
            ((Calendar)comparable).setTime((Date)object2);
            object = new StringBuilder("");
            ((StringBuilder)object).append(((Calendar)comparable).get(1)).append("-").append(((Calendar)comparable).get(2) + 1).append("-").append(((Calendar)comparable).get(5));
            this.intermediateExpDate = ((StringBuilder)object).toString();
        }
        if (!verificationWarning.isEmpty() && verificationFailureType == 1) {
            throw new SQLWarning(verificationWarning);
        }
    }

    public Cipher getD() {
        return this.decryptCipher;
    }

    public Cipher getE() {
        return this.encryptCipher;
    }

    public boolean getEncryption() {
        return this.doEncrypt;
    }

    public boolean getIsLocalListener() {
        return this.isLocalListener;
    }

    public void SendChar(int n) throws IOException {
        this.fm_output.write((byte)n);
    }

    public void SendInteger(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        while (n2-- > 0) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
        }
        this.Send(byArray);
    }

    public void SendIntegerR(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        this.Send(byArray);
    }

    public void SendInteger4(int n) throws IOException {
        this._int4buf[3] = (byte)(n >>> 24);
        this._int4buf[2] = (byte)(n >>> 16);
        this._int4buf[1] = (byte)(n >>> 8);
        this._int4buf[0] = (byte)n;
        this.fm_output.write(this._int4buf);
    }

    public void SendInteger8(long l) throws IOException {
        this._int8buf[7] = (byte)(l >>> 56);
        this._int8buf[6] = (byte)(l >>> 48);
        this._int8buf[5] = (byte)(l >>> 40);
        this._int8buf[4] = (byte)(l >>> 32);
        this._int8buf[3] = (byte)(l >>> 24);
        this._int8buf[2] = (byte)(l >>> 16);
        this._int8buf[1] = (byte)(l >>> 8);
        this._int8buf[0] = (byte)l;
        this.fm_output.write(this._int8buf);
    }

    public void SendInteger2(int n) throws IOException {
        this._int2buf[1] = (byte)(n >>> 8);
        this._int2buf[0] = (byte)n;
        this.fm_output.write(this._int2buf);
    }

    public void Send(byte[] byArray) throws IOException {
        this.fm_output.write(byArray);
    }

    public void Send(byte[] byArray, int n) throws IOException {
        this.Send(byArray, 0, n);
    }

    public void Send(byte[] byArray, int n, int n2) throws IOException {
        this.fm_output.write(byArray, n, byArray.length - n < n2 ? byArray.length - n : n2);
        if (byArray.length - n < n2) {
            for (int i = byArray.length - n; i < n2; ++i) {
                this.fm_output.write(0);
            }
        }
    }

    public int ReceiveChar() throws SQLException {
        int n = 0;
        try {
            n = this.fm_input.read();
            if (n < 0) {
                throw new FMSQLException("Unexpected end of data.", "08S01", 27003);
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27004);
        }
        return n;
    }

    public int ReceiveInteger(int n) throws SQLException {
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = this.fm_input.read();
                if (n3 < 0) {
                    throw new FMSQLException("Unexpected end of data.", "08S01", 27005);
                }
                n2 |= n3 << 8 * i;
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27006);
        }
        return n2;
    }

    public int ReceiveIntegerR(int n) throws SQLException {
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = this.fm_input.read();
                if (n3 < 0) {
                    throw new FMSQLException("Unexpected end of data.", "08S01", 27007);
                }
                n2 = n3 | n2 << 8;
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27008);
        }
        return n2;
    }

    public long ReceiveInteger8() throws SQLException, IOException {
        if (this.fm_input.read(this._int8buf) != 8) {
            throw new FMSQLException("Unexpected end of data.", "08S01", 27009);
        }
        return (this._int8buf[7] & 0xFF) << 56 | (this._int8buf[6] & 0xFF) << 48 | (this._int8buf[5] & 0xFF) << 40 | (this._int8buf[4] & 0xFF) << 32 | (this._int8buf[3] & 0xFF) << 24 | (this._int8buf[2] & 0xFF) << 16 | (this._int8buf[1] & 0xFF) << 8 | this._int8buf[0] & 0xFF;
    }

    public int ReceiveInteger4() throws SQLException, IOException {
        if (this.fm_input.read(this._int4buf) != 4) {
            throw new FMSQLException("Unexpected end of data.", "08S01", 27010);
        }
        return (this._int4buf[3] & 0xFF) << 24 | (this._int4buf[2] & 0xFF) << 16 | (this._int4buf[1] & 0xFF) << 8 | this._int4buf[0] & 0xFF;
    }

    public int ReceiveInteger2() throws SQLException, IOException {
        int n = this.fm_input.read(this._int2buf);
        if (n != 2) {
            throw new FMSQLException("Unexpected end of data.", "08S01", 27011);
        }
        return (this._int2buf[1] & 0xFF) << 8 | this._int2buf[0] & 0xFF;
    }

    public String ReceiveString(Encoding encoding, int n) throws SQLException {
        int n2 = 0;
        byte[] byArray = this.byte_buf;
        try {
            int n3 = byArray.length;
            boolean bl = false;
            if (n <= 0) {
                byArray[n2] = 0;
                bl = true;
            }
            block2: while (!bl) {
                while (n2 < n3) {
                    int n4 = this.fm_input.read();
                    if (n4 < 0) {
                        throw new FMSQLException("Unexpected end of data.", "08S01", 27012);
                    }
                    if (n4 == 0) {
                        byArray[n2] = 0;
                        bl = true;
                        continue block2;
                    }
                    byArray[n2++] = (byte)n4;
                    if (n2 >= n) {
                        byArray[n2] = 0;
                        bl = true;
                        continue block2;
                    }
                    if (n2 < n3) continue;
                    byte[] byArray2 = new byte[n3 *= 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    byArray = byArray2;
                }
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27013);
        }
        return encoding.decode(byArray, 0, n2);
    }

    public String ReceiveString(Encoding encoding) throws SQLException {
        int n = 0;
        byte[] byArray = this.byte_buf;
        try {
            int n2 = byArray.length;
            boolean bl = false;
            block2: while (!bl) {
                while (n < n2) {
                    int n3 = this.fm_input.read();
                    if (n3 < 0) {
                        throw new FMSQLException("Unexpected end of data.", "08S01", 27014);
                    }
                    if (n3 == 0) {
                        byArray[n] = 0;
                        bl = true;
                        continue block2;
                    }
                    byArray[n++] = (byte)n3;
                    if (n < n2) continue;
                    byte[] byArray2 = new byte[n2 *= 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27015);
        }
        return encoding.decode(byArray, 0, n);
    }

    public byte[] Receive(int n) throws SQLException {
        byte[] byArray = new byte[n];
        this.Receive(byArray, 0, n);
        return byArray;
    }

    public void Receive(byte[] byArray, int n, int n2) throws SQLException {
        try {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = this.fm_input.read(byArray, n + i, n2 - i);
                if (n3 >= 0) continue;
                throw new FMSQLException("Unexpected end of data.", "08S01", 27016);
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27017);
        }
    }

    public void flush() throws SQLException {
        try {
            this.fm_output.flush();
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01", 27018);
        }
    }

    public void close() throws IOException {
        this.fm_output.close();
        this.fm_input.close();
        this.connection.close();
    }
}

