/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global require, csInterface, module, __dirname */

(function () {
    "use strict";

    // EVENT SUBCATEGORIES
    exports.CREMA_ACTION        = "CremaAction";    // for user actions
    exports.CREMA_FUNNEL        = "CremaFunnel";    // for progress in the analytics funnel
    exports.GENERATOR           = "Generator";      // special one to use for the "generator: rendered..." event

    // FUNNEL STRINGS
    exports.DLG_LAUNCHED_FROM_MENU_FOR_SELECTION             = "DialogLaunchedFromMenuForSelectionOfSize_";
    exports.DLG_LAUNCHED_FROM_MENU_FOR_DOCUMENT              = "DialogLaunchedFromMenuForDoc";
    exports.DLG_LAUNCHED_FROM_MENU_FOR_DOCUMENT_ARTBOARDS    = "DialogLaunchedFromMenuForDocArtboards";

    exports.PANEL_LAUNCHED      = "PanelLaunched";
    exports.SAVED               = "SavedSettings";
    exports.SAVED_WITH_CHANGES  = "SavedSettingWithChanges";
    exports.SAVED_NO_CHANGES    = "SavedSettingNoChanges";
    exports.EXPORT              = "Exported";
    exports.EXPORT_MANUAL       = "ExportedManual";
    exports.EXPORT_AUTO         = "ExportedAuto";
    exports.EXPORT_BOTH         = "ExportedBoth";

    exports.DLG_EXPORT_FOR_DOCUMENT_DONE                = "Success:DialogExportedDocument";
    exports.DLG_EXPORT_FOR_DOCUMENT_ARTBOARDS_DONE      = "Success:DialogExportedDocumentArtboards_";
    exports.DLG_EXPORT_FOR_SELECTION_DONE               = "Success:DialogExportedSelectionOfSize_";
    
    exports.QUICK_EXPORT_FOR_DOCUMENT_START             = "StartQuickExportDocument";
    exports.QUICK_EXPORT_FOR_DOCUMENT_ARTBOARDS_START   = "StartQuickExportDocumentArtboards";
    exports.QUICK_EXPORT_FOR_SELECTION_START            = "StartQuickExportSelectionOfSize_";
    exports.QUICK_EXPORT_FOR_DOCUMENT_DONE              = "Success:QuickExportedDocument";
    exports.QUICK_EXPORT_FOR_DOCUMENT_ARTBOARDS_DONE    = "Success:QuickExportedDocumentArtboards_";
    exports.QUICK_EXPORT_FOR_SELECTION_DONE             = "Success:QuickExportedSelectionOfSize_";

    // ACTION STRINGS
    exports.SAVE_SWITCH_DOC             = "SavedSwitchDoc";
    exports.GEN_RENDERED_CREMA          = "Generator: Rendered With Crema";
    exports.SAVE_EXPORT                 = "SavedExport";
    exports.NO_SAVE_EXPORT              = "ExportNoSave";

    exports.FINISH_DONE                 = "FinishedDone";
    exports.FINISH_EXTRACT              = "FinishedExtract";
    exports.DLG_FINISH_EXPORT           = "DialogFinishedExport";

    exports.FAILED_TO_REOPEN            = "FailedToReopenToSave";

    exports.LEARN_MORE_CLICK            = "ClickedLearnMore";
    exports.LINK_TO_EXTRACT_CLICK       = "ClickedLinkToExtract";

    exports.DLG_CANCEL_WHILE_LOADING    = "DialogCancelWhileLoading";
    exports.DLG_CLICK_CANCEL            = "DialogClickedCancel";
    exports.CLICK_COG                   = "ClickedCog";
    exports.CLICK_DONE                  = "ClickedDone";
    exports.DLG_CLICK_EXPORT            = "DialogClickedExport";
    exports.CLICK_EXTRACT               = "ClickedExtract";
    exports.CLICK_SETTINGS              = "ClickedSettings";

    exports.CHANGED_RES_MAIN        = "ChangedResolutionInMain";
    exports.CHANGED_RES_SETTINGS    = "ChangedResolutionInSettings";

    exports.SETTING_WH_VALID        = "SettingWidthOrHeightValid";
    exports.SETTING_WH_INVALID      = "SettingWidthOrHeightInvalid";
    exports.SETTING_WH_CORRECTED    = "SettingWidthOrHeightCorrected";
    exports.SETTING_WH_CLEARED      = "SettingWidthOrHeightCleared";

    exports.SETTING_SCALE_VALID     = "SettingScaleValid";
    exports.SETTING_SCALE_INVALID   = "SettingScaleInvalid";
    exports.SETTING_SCALE_CORRECTED = "SettingScaleCorrected";
    exports.SETTING_SCALE_SELECTOR  = "SettingScaleSelector";

    exports.WEBSOCK_CLOSED          = "WebSocketClosed";
    exports.WEBSOCK_CONNECTED       = "WebSocketConnected";
    exports.WEBSOCK_RETRY           = "WebSocketRetry";

    exports.LAYER_CLIPPEDBY_DOC_DLG_EXP         = "LayerClippedByDocBounds_onDialogExport";
    exports.LAYER_CLIPPEDBY_DOC_QUICK_EXP       = "LayerClippedByDocBounds_onQuickExport";
    exports.LAYER_CLIPPEDBY_DOC_PREV            = "LayerClippedByDocBounds_onPreview";
    exports.LAYER_OUTSIDE_DOC_DLG_EXP           = "LayerOutsideDocBounds_onDialogExport";
    exports.LAYER_OUTSIDE_DOC_QUICK_EXP         = "LayerOutsideDocBounds_onQuickExport";
    exports.LAYER_OUTSIDE_DOC_PREV              = "LayerOutsideDocBounds_onPreview";
    exports.LAYER_CLIPPEDBY_ARTBOARD_DLG_EXP    = "LayerClippedByArtboardBounds_onDialogExport";
    exports.LAYER_CLIPPEDBY_ARTBOARD_QUICK_EXP  = "LayerClippedByArtboardBounds_onQuickExport"; // not yet used
    exports.LAYER_CLIPPEDBY_ARTBOARD_PREV       = "LayerClippedByArtboardBounds_onPreview";
    exports.LAYER_EMPTY_DLG_EXP                 = "LayerIsEmpty_onDialogExport";
    exports.LAYER_EMPTY_QUICK_EXP               = "LayerIsEmpty_onQuickExport";
    exports.LAYER_EMPTY_PREV                    = "LayerIsEmpty_onPreview";
    exports.ARTBOARD_EMPTY_DLG_EXP              = "ArtboardIsEmpty_onDialogExport";
    exports.ARTBOARD_EMPTY_QUICK_EXP            = "ArtboardIsEmpty_onQuickExport";
    exports.ARTBOARD_EMPTY_PREV                 = "ArtboardIsEmpty_onPreview";
    exports.GROUP_EMPTY_DLG_EXP                 = "GroupIsEmpty_onDialogExport";
    exports.GROUP_EMPTY_QUICK_EXP               = "GroupIsEmpty_onQuickExport";
    exports.GROUP_EMPTY_PREV                    = "GroupIsEmpty_onPreview";
    exports.EXPORTING_FEWER_THAN_SELECTED       = "FewerItemsThanSelected_onDialogExport";
    exports.EXPORTING_FEWER_THAN_SELECTED_QUICK = "FewerItemsThanSelected_onQuickExport";
    exports.WRITEERROR_ON_DLG_EXPORT            = "WriteError_onDialogExport";
    exports.WRITEERROR_ON_QUICK_EXPORT          = "WriteError_onQuickExport";

    // DATA STRINGS
    exports.COMPS_GROUP             = "CremaComps"; // used in generatorModel, but not actually relevant
    exports.SETTINGS_GROUP          = "CremaSettings";
    exports.EXPORT_ASSETS_GROUP     = "CremaExportedAssets";
    exports.EXPORT_SUMMARY_GROUP    = "CremaExportSummary";

    exports.EXPORTTYPE  = "ExportType"; // "dialog" or "quick"
    exports.FORMAT      = "Format";
    exports.QUALITY     = "Quality"; // only for jpg
    exports.INTERP      = "InterpolationType";
    exports.CANVAS      = "CanvasSpecified"; // true or false
    exports.WIDTH       = "Width";
    exports.HEIGHT      = "Height";
    exports.SCALE       = "Scale";
    exports.ITEMTYPE    = "ItemType"; // document, artboard or selection
    exports.ITEMCOUNT   = "ItemCount";
    exports.SECONDS     = "ElapsedSeconds";
    
    // CONSTANTS
    exports.DIALOG      = "Dialog";
    exports.QUICK       = "Quick";
    exports.DOCUMENT    = "Document";
    exports.ARTBOARD    = "Artboard";
    exports.SELECTION   = "Selection";

}());

