/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, node: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global  */
"use strict";

var $ = require("jquery"),
    _ = require("underscore"),
    Q = require("q"),
    Backbone = require('backbone'),
    Strings = require("./LocStrings"),
    Template = require("./TemplateLoader");

var SemiModalDialogView = Backbone.View.extend({
    
    template: _.template(Template.loadTemplate("../templates/semiModalDialogView.html")),
    
    events: {
        "click .semi-modal-wash": "washHide",
        "click .semi-modal-dialog": "handleDialogBGClick",
        "click button": "handleActionClick",
        "click input[type='checkbox']": "handleDontShowCheckboxChange"
    },

    render: function () {
        this.renderTemplate();
        this.$dontShowAgainCheckbox = this.$("input[type='checkbox']");
        return this;
    },
    
    renderTemplate: function () {
        var context = Template.createTemplateContext(Strings, this.model.attributes);
        this.$el.html(this.template(context));
    },
    
    handleDontShowCheckboxChange: function (evt) {
        var isChecked = this.$dontShowAgainCheckbox.is(':checked');
        if (isChecked) {
            this.trigger("dialog-action", "no-show-check");
        } else {
            this.trigger("dialog-action", "show-check");
        }
    },
    
    handleDialogBGClick: function (evt) {
        evt.stopPropagation();
    },
    
    doAction: function (actionCode) {
        this.trigger("dialog-action", actionCode);
        this.showPromise.resolve(actionCode);
        this.hide();
    },
    
    handleActionClick: function (evt) {
        var $target = $(evt.currentTarget);
        this.doAction($target.attr("data-action-code"));
    },

    show: function (evt) {
        this.$el.removeClass("hide");
        this.showPromise = Q.defer();
        return this.showPromise.promise;
    },
    
    washHide: function (evt) {
        this.doAction("cancel");
    },
    
    hide: function (evt) {
        this.$el.addClass("hide");
        this.showPromise = null;
    }
    
});

module.exports = SemiModalDialogView;