/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global require: true, $: true, exports: true, csInterface: true*/

(function () {

    "use strict";
    
    var LayerCollectionView = require("./layerCollectionView.js"),
        Backbone = require("backbone"),
        Headlights = require("./utils/Headlights"),
        PanelView = require("./panelView.js"),
        panelView,
        GeneratorModel = require("./generatorModel.js"),
        generatorModel;
    
    var init = function () {
        csInterface.setContextMenu("<menu></menu>", function() {});
        generatorModel = new GeneratorModel();

        $("html").attr("lang", csInterface.getHostEnvironment().appUILocale.substr(0, 2));

        panelView = new PanelView({ el: $("body"), model: new Backbone.Model(), generatorModel: generatorModel });
        panelView.render();
        
        var layerCollectionView,
            $lists = $(".lists");
        
        layerCollectionView = new LayerCollectionView({
            collection: generatorModel.layerCollection,
            defaultSettingsModel: generatorModel.defaultSettingsModel
        });
        layerCollectionView.listenTo(panelView, "openSettingsDialog", layerCollectionView.openSettingsDialog);
        $lists.append(layerCollectionView.render().$el);

        Headlights.logEvent(Headlights.CREMA_FUNNEL, Headlights.PANEL_LAUNCHED);
    };

    exports.init = init;
    
}());
