/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global define: true, require:true, _:true, $:true, module: true */

"use strict";

var Backbone = require('backbone'),
    GenSettingsModel = require('./genSettingsModel.js');

var GenSettingsCollection = Backbone.Collection.extend({

    model: GenSettingsModel,
    initialize: function () {
        this.listenTo(this, "remove", this.selectNext);
        this.listenTo(this, "parentSelectionChange", this.subSelect);
    },
    allDisabled: function () {
        return this.every(function (model) {
            return model.get("disabled");
        });
    },
    subSelect: function (isSelected) {
        var notSelected = this.reject(function (model) {
                return model.get("selected");
            });
        _.invoke(notSelected, "set", {subselected: isSelected});
    },
    selectNext: function (model, collection, options) {
        if (this.size() > 0 && model.get("selected")) {
            var index = options.index === this.size() ? --options.index : options.index;
            var newModel = this.at(options.index);
            if (newModel) {
                newModel.set("selected", true);
            }
        }
    },
    serializeToLayerName: function () {
        var self = this,
            output = "";
        
        this.forEach(function (genSetting) {
            
            var sItem = genSetting.serializeToLayerName();
            if (sItem && sItem !== "") {
                if (output !== "") {
                    output += ", ";
                }
                output += sItem;
            }
        });
        return output;
    }
});


module.exports = GenSettingsCollection;
