/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global window: true, require: true, $: true, exports: true, csInterface: true*/

(function () {

    "use strict";
    
    var _ = require("underscore"),
        Backbone = require("backbone"),
        Headlights = require("./utils/Headlights"),
        JSXRunner = require("./JSXRunner"),
        DialogView = require("./dialogView.js"),
        dialogView,
        dialogModel,
        GeneratorModel = require("./generatorModel.js"),
        generatorModel;
    
    var init = function () {
        csInterface.setContextMenu("<menu></menu>", function () {});
        dialogModel =  new Backbone.Model();
        
        generatorModel = new GeneratorModel();
        generatorModel.once("docinfo-loaded", function (docinfo) {
            var selectionSize = docinfo && docinfo._selectionById ? docinfo._selectionById.length : 0;
            if (generatorModel.get("isPerformingDocumentExport")) {
                Headlights.logEvent(Headlights.CREMA_FUNNEL, Headlights.DLG_LAUNCHED_FROM_MENU_FOR_DOCUMENT);
            } else if (generatorModel.get("isPerformingDocumentArtboardExport")) {
                Headlights.logEvent(Headlights.CREMA_FUNNEL, Headlights.DLG_LAUNCHED_FROM_MENU_FOR_DOCUMENT_ARTBOARDS);
            } else {
                Headlights.logEvent(Headlights.CREMA_FUNNEL, Headlights.DLG_LAUNCHED_FROM_MENU_FOR_SELECTION + selectionSize);
            }
        });
        
        var runGeneratorFaster = function () {
            return generatorModel.get("layersLoading") || dialogModel.get("exporting");
        };
        
        var pumpGeneratorQueue = _.partial(JSXRunner.runJSX, "flushGeneratorQueue"),
            pumpPending = false,
            pumpGeneratorOnTimer = function() {
                if (pumpPending) {
                    return;
                }
                pumpPending = true;
                var corePumpCallback = function(){
                    pumpPending = false;
                    pumpGeneratorQueue(pumpGeneratorOnTimer);
                };
                if (runGeneratorFaster()) {
                    window.requestAnimationFrame(corePumpCallback);
                } else {
                    _.delay(corePumpCallback, 500);
                }
            };
        
        pumpGeneratorQueue(pumpGeneratorOnTimer);

        $("html").attr("lang", csInterface.getHostEnvironment().appUILocale.substr(0, 2));

        
        dialogView = new DialogView({ el: $("body"), model: dialogModel, generatorModel: generatorModel });
        dialogView.render();

        //called just before unload (in theory)
        window.cep.util.registerExtensionUnloadCallback(function () {
            //awaiting fix: https://watsonexp.corp.adobe.com/#bug=3754552
            console.log("Fix for Watson #3754552 is in!");
            //same as escape
            dialogView.cancelDialog();
        });
        
    };

    exports.init = init;
    
}());
