/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global define: true, require: true */
"use strict";

var Backbone    = require("backbone"),
    _           = require("underscore"),
    $           = require("jquery"),
    Template    = require("./TemplateLoader"),
    Strings     = require("./LocStrings"),
    Headlights  = require("./utils/Headlights");

  

var AssetButtonBar = Backbone.View.extend({
    events: {
        "click button": "dispatchButtonAction",
        "click .settings-icon": "dispatchButtonAction"
    },
    template: _.template(Template.loadTemplate("../templates/assetButtonBar.html")),
    initialize: function (options) {
        this.options = options || {};
        if(this.options.isEditable === undefined) {
            this.options.isEditable = true;
        }
        if(this.options.isMultiSelect === undefined) {
            this.options.isMultiSelect = false;
        }
    },
    className: "toggle-bar",
    render: function() {
        var context = Template.createTemplateContext(Strings, {});
        
        this.$el.html(this.template(context));
        this.$editButton = this.$(".settings-icon");
        if(!this.options.isEditable) {
            this.$editButton.remove();
        }
        return this;
    },
    getButtonForDataVal: function(val) {
        return this.$("button[data-val='"+ val +"']");
    },
    editButtonAction: function() {
    },
    deselectAll: function() {
        this.$(".selected").removeClass("selected");
    },
    standardButtonAction: function($button) {
        Headlights.logEvent(Headlights.CREMA_ACTION, Headlights.CHANGED_RES_MAIN);
        if(!this.options.isMultiSelect) {
            this.deselectAll();
            $button.addClass("selected");
        } else {
            this.toggleButton($button);
        }
    },
    dispatchButtonAction: function(e) {
        var $button = $(e.currentTarget);
        if($button.is(this.$editButton)) {
            Headlights.logEvent(Headlights.CREMA_ACTION, Headlights.CLICK_COG);
            this.editButtonAction();
            return;
        }
        this.standardButtonAction($button);
    },
    toggleButton: function($button) {
        $button.toggleClass("selected");
    },
    updateValue: function(val) {
        this.model.set("designedAt", val);
    }
});


module.exports = AssetButtonBar;