/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global define: true, require: true */
"use strict";

var Backbone = require("backbone"),
    _ = require("underscore"),
    GenableCollectionView = require("./genableCollectionView.js"),
    Template = require("./TemplateLoader"),
    Strings = require("./LocStrings"),
    photoshopDelegate = require("./photoshopDelegate");


var LayerCollectionView = GenableCollectionView.extend({
    initialize: function (options) {
        options = _.extend(options, {
            id: "layers-container",
            viewId: "list-layers",
            listId: "preview-list"
        });
        GenableCollectionView.prototype.initialize.call(this, options);
        this.options = options;
        this.hasRegisteredPhotoshopEvents = false;
    },
    openSettingsDialog: function () {
        this.buttonBar.editButtonAction();
    },
    emptyTemplate: _.template(Template.loadTemplate("../templates/emptyLayersView.html"))
});


module.exports = LayerCollectionView;