/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global define: true, require:true, _:true, $:true, module: true */

"use strict";

var Backbone = require('backbone'),
    _ = require("underscore"),
    Template = require("./TemplateLoader"),
    GenableView = require("./genableView.js"),
    ButtonViews = require("./components/buttonViews.js"),
    Strings = require("./LocStrings");

var GenableCollectionView = Backbone.View.extend({
    initialize: function (options) {
        this.listenTo(this.collection, "remove", this.removeRenderedSetting);
        this.listenTo(this.collection, "add", this.renderViewItem);
        this.listenTo(this.collection, "change:rendableState", this.renderViewItem);
        this.listenTo(this.collection, "reset", this.clearView);
        this.initialClass = options.initialClass || "";
        this.listId = options.listId || "";
        this.viewId = options.viewId || "";
        this.filteredList = options.filteredList;
        this._renderedViews = [];
    },
    className: "box",
    ViewClass: GenableView,
    template: _.template(Template.loadTemplate("../templates/genableListView.html")),
    genablesEmpty: true,
    render: function () {
        var context = Template.createTemplateContext(Strings, {
            viewId: this.viewId,
            listId: this.listId,
            initialClass: this.initialClass
        });
        this.$el.html(this.template(context));
        this.$genableList = this.$("." + this.listId);
        this.$tabContent = this.$("#" + this.viewId);
        if (this.collection.size() === 0) {
            this.$genableList.append(this._getEmptyHTML());
        } else {
            this.collection.each(this.renderViewItem, this);
        }
        return this;
    },
    _getEmptyHTML: function () {
        return this.emptyTemplate(Template.createTemplateContext(Strings, {}));
    },
    removeRenderedSetting: function (model) {
        if (this._renderedViews[model.cid]) {
            this._renderedViews[model.cid].remove();
            delete this._renderedViews[model.cid];
        } else {
            console.warn("[genableCollectionView:removeRenderedSetting] tried to remove a model that has not rendered view");
        }
        if (Object.keys(this._renderedViews).length === 0) {
            this.clearView();
        }
    },
    clearView: function () {
        this.$genableList.empty();
        this.$genableList.append(this._getEmptyHTML());
        this.genablesEmpty = true;
    },
    renderViewItem: function (genableModel) {
        if (this.genablesEmpty) {
            this.$genableList.empty();
            this.genablesEmpty = false;
        }
        var genableView;

        if (this.canRenderItem(genableModel)) {
            genableView = new this.ViewClass({model: genableModel});
            this.$genableList.append(genableView.render().$el);
            this._renderedViews[genableModel.cid] = genableView;
        }
    },
    canRenderItem: function(genableModel) {
        if (this._renderedViews[genableModel.cid]) {
            return false;
        }
        return true;
    }
});

module.exports = GenableCollectionView;