/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global define: true, require: true */

"use strict";

var Backbone = require('backbone'),
    GenableModel = require('./genableModel.js'),
    GenSettingsCollection = require("./genSettingsCollection.js"),
    ActionRollup = require("./actionRollup.js");


var DocumentLayer = GenableModel.extend({
    defaults: function () {
        return {
            guid: "",
            compId: "",
            compIndex: "",
            layerId: DocumentLayer.GetDefaultLayerID(),
            layerSettings: new GenSettingsCollection(),
            name: "",
            invisible: false,
            //this is used for views
            selected: true,
            //isActive is the model communication
            isActive: true,
            isDefaultSettingsLayer: false,
            isDocument: true,
            dimensions: {width: -1, height: -1},
            boundsAreAccurate: false,
            dpi: 72
        };
    },
    _updateModelMetaData: function(json) {
        ActionRollup.updateDocumentMetaData(this.get("layerId"), {assetSettings: json});
    },
});

DocumentLayer.GetDefaultLayerID = function() {
    return 0;
};
DocumentLayer.isDocumentLayerId = function(layerID) {
    return DocumentLayer.GetDefaultLayerID() === layerID;
};
module.exports = DocumentLayer;
