/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */
/*global define: true, require:true, _:true, $:true, module: true */

"use strict";

var Backbone = require('backbone'),
    GenableModel = require('./genableModel.js'),
    JSXRunner = require("./JSXRunner"),
    ActionRollup = require("./actionRollup.js"),
    ServerInterface = require("./serverInterface.js"),
    CompSetting = require("./compSettingsModel.js");

var CompModel = GenableModel.extend({
    
    thumbnailRoute: "layercompthumb/",
    
    initialize: function (attributes, options) {
        GenableModel.prototype.initialize.call(this, attributes, options);
        this.emptyState();
    },
    
    emptyState: function () {
        this.set("imageURL", ServerInterface.SERVER_HOST + ':' + ServerInterface.getCachedCremaPort() + '/' + this.thumbnailRoute + this.getGenableId() + ".png");
    },
    
    canBeEmpty: true,
    
    getGenableId: function () {
        return this.get("compId");
    },
    addLayerSettings: function (settings) {
        settings = _.extend(settings || {}, {
            originalDimensions: _.extend(this.get("dimensions"), {dpi: this.get("dpi")})
        });
        return this.layerSettingsCollection.add(new CompSetting(settings));
    }
});

module.exports = CompModel;
