/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, node: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global window:true, localStorage: true */
"use strict";

var $ = require("jquery"),
    _ = require("underscore"),
    Backbone = require('backbone'),
    Strings = require("./LocStrings"),
    Template = require("./TemplateLoader"),
    localPrefs = require("./utils/localPrefs.js"),
    CloudCoreSync = require("./cloudCoreSync.js"),
    Headlights  = require("./utils/Headlights");

var AlertView = Backbone.View.extend({
    
    template: _.template(Template.loadTemplate("../templates/alertView.html")),
    
    $learnMore: $(),
    $linkToExtract: $(),
    
    initialize: function (options) {
        this.$container = options.container;
        this.generatorModel = options.generatorModel;
        this.checkDismissed();
    },
    
    checkDismissed: function () {
        
        if (localPrefs.getPref("hasBeenDismissed") !== Strings.ALERT_PITCH_ID) {
            this.$el.removeClass("hide");
            this.$container.addClass("alerts");
            this.listenTo(this.generatorModel, "docinfo-loaded", this.renderAlertForDoc);
        }
    },
    
    events: {
        "click .close": "closeAlert",
        "click .learn-more": "handleLearnMoreClick",
        "click .link-to-extract": "handleLinkToExtractClick"
    },
    
    cacheElements: function () {
        this.$learnMore = this.$(".alert-learn-more");
        this.$linkToExtract = this.$(".alert-link-to-extract");
    },
    
    render: function () {
        var context = Template.createTemplateContext(Strings, this.model.attributes);
        this.$el.html(this.template(context));
        this.cacheElements();
        return this;
    },
    
    renderLearnMore: function () {
        this.$linkToExtract.addClass("hide");
        this.$learnMore.removeClass("hide");
    },
    
    renderLinkToExtract: function () {
        this.$learnMore.addClass("hide");
        this.$linkToExtract.removeClass("hide");
    },
    
    renderAlertForDoc: function () {
        CloudCoreSync.canOpenFileInExtractWeb(this.getCurrentDocPath()).then(function (canOpenInExtract) {
            if (canOpenInExtract) {
                this.renderLinkToExtract();
            } else {
                this.renderLearnMore();
            }
        }.bind(this), this.renderLearnMore.bind(this));
    },
    
    handleLearnMoreClick: function () {
        Headlights.logEvent(Headlights.CREMA_ACTION, Headlights.LEARN_MORE_CLICK);
        global.cep.util.openURLInDefaultBrowser(Strings.EXTRACT_CC_GOURL);
    },
    
    handleLinkToExtractClick: function () {
        Headlights.logEvent(Headlights.CREMA_ACTION, Headlights.LINK_TO_EXTRACT_CLICK);
        CloudCoreSync.openFileInExtractWeb(this.getCurrentDocPath());
    },
    
    getCurrentDocPath: function () {
        return this.generatorModel.get("docFilepath");
    },
    
    closeAlert: function () {
        this.$el.addClass("hide");
        this.$container.removeClass("alerts");
        localPrefs.setPref("hasBeenDismissed", Strings.ALERT_PITCH_ID);
    }
});

module.exports = AlertView;
