(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __slice = [].slice;

  Bridge = (function() {
    Bridge.prototype.locale = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appUILocale.toLowerCase();

    Bridge.prototype.data = {
        application: {
          id: 'phxs',
          name: 'GuideGuide Photoshop',
          localization: JSON.parse(window.__adobe_cep__.getHostEnvironment()).appUILocale,
          env: 'production',
          guideguideVersion: '3.1.4',
          checkForUpdates: true
        }
      };

    Bridge.prototype.csInterface = {};

    function Bridge(args) {
      this.dismissAlert = __bind(this.dismissAlert, this);
      this.updateTheme = __bind(this.updateTheme, this);
      this.alert = __bind(this.alert, this);
      this.hideLoader = __bind(this.hideLoader, this);
      this.showLoader = __bind(this.showLoader, this);
      this.toHash = __bind(this.toHash, this);
      this.showUpdateInfo = __bind(this.showUpdateInfo, this);
      this.showUpdateIndicator = __bind(this.showUpdateIndicator, this);
      this.openURL = __bind(this.openURL, this);
      this.error = __bind(this.error, this);
      this.log = __bind(this.log, this);
      this.updateCustomField = __bind(this.updateCustomField, this);
      this.selectTab = __bind(this.selectTab, this);
      this.hideImporter = __bind(this.hideImporter, this);
      this.refreshSettings = __bind(this.refreshSettings, this);
      this.refreshSets = __bind(this.refreshSets, this);
      this.localizeUI = __bind(this.localizeUI, this);
      this.getFormData = __bind(this.getFormData, this);
      this.getDocumentInfo = __bind(this.getDocumentInfo, this);
      this.resetGuides = __bind(this.resetGuides, this);
      this.toggleGuides = __bind(this.toggleGuides, this);
      this.addGuides = __bind(this.addGuides, this);
      this.setData = __bind(this.setData, this);
      this.getData = __bind(this.getData, this);
      this.init = __bind(this.init, this);
      args = args || {};
      if (args.ui) {
        this.ui = args.ui;
      }
    }

    Bridge.prototype.init = function(core) {
      this.csInterface = new CSInterface();
      return this.ui.init(core);
    };

    Bridge.prototype.getData = function() {
      var data = JSON.parse(localStorage.getItem('guideguide'));
      data = data || this.data;
      data.application = this.data.application;
      return data;
    };

    Bridge.prototype.setData = function(data) {
      return localStorage.setItem('guideguide', JSON.stringify(data));
    };

    Bridge.prototype.addGuides = function(guides, callback) {
      var fn = "guideguide.addGuides('" + JSON.stringify(guides) + "')";
      this.csInterface.evalScript(fn, callback);
    };

    Bridge.prototype.toggleGuides = function() {
      this.csInterface.evalScript("guideguide.toggleGuides()");
    };

    Bridge.prototype.resetGuides = function(guides) {
      var fn = "guideguide.clearGuides('" + JSON.stringify(guides) + "')";
      this.csInterface.evalScript(fn);
    };

    Bridge.prototype.getDocumentInfo = function(callback) {
      this.csInterface.evalScript("guideguide.getInfo()", function(info){
        callback(JSON.parse(info));
      });
    };

    Bridge.prototype.getFormData = function() {
      return this.ui.getFormData();
    };

    Bridge.prototype.localizeUI = function() {
      return this.ui.localizeUI();
    };

    Bridge.prototype.refreshSets = function(sets) {
      return this.ui.refreshSets(sets);
    };

    Bridge.prototype.refreshSettings = function(data) {
      return this.ui.refreshSettings(data);
    };

    Bridge.prototype.hideImporter = function() {
      return this.ui.hideImporter();
    };

    Bridge.prototype.selectTab = function(tab) {
      return this.ui.selectTab(tab);
    };

    Bridge.prototype.updateCustomField = function(string) {
      return this.ui.updateCustomField(string);
    };

    Bridge.prototype.log = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (console.log.apply) {
        return console.log.apply(console, args);
      } else {
        return console.log(args.join(" "));
      }
    };

    Bridge.prototype.error = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (console.error.apply) {
        return console.error.apply(console, args);
      } else {
        return console.error(args.join(" "));
      }
    };

    Bridge.prototype.openURL = function(url) {
      return (new CSInterface()).openURLInDefaultBrowser(url);
    };

    Bridge.prototype.showUpdateIndicator = function(data) {
      return this.ui.showUpdateIndicator(data);
    };

    Bridge.prototype.showUpdateInfo = function() {
      return this.ui.showUpdateInfo();
    };

    Bridge.prototype.toHash = function(string) {
      return CryptoJS.SHA1(string).toString();
    };

    Bridge.prototype.showLoader = function() {
      return this.ui.showLoader();
    };

    Bridge.prototype.hideLoader = function() {
      return this.ui.hideLoader();
    };

    Bridge.prototype.alert = function(args) {
      return this.ui.alert(args);
    };

    Bridge.prototype.updateTheme = function(colors) {
      return this.ui.updateTheme(colors);
    };

    Bridge.prototype.dismissAlert = function() {};

    return Bridge;

  })();

}).call(this);
